// CmObjRef.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Object reference definition used internally by the reserve.
// -----------------------------------------------------------------

#ifndef _CMOBJREF_H
#define _CMOBJREF_H

#include <cm/include/cmobject.h>

class CmObjectReference : public CmObject {     // Reference definition.
public:
  CmObjectReference(int);                       // Reference constructor.
  CmObjectReference(CmObject*);                 // Reference constructor.
  CmObjectReference(int, CmObject*);            // Reference constructor.

  int       key   () const;                     // Return key.
  CmObject* object() const;                     // Return object ptr.

  CMOBJECT_DEFINE(CmObjectReference, CmObject)  // Define base functions.

  Bool     isEqual(CmObject*) const;            // Reference compare.
  int      compare(CmObject*) const;            // Reference compare.
  unsigned hash   (unsigned ) const;            // Hash reference.

  enum { KEYS=0, OBJECTS=1 };                   // Compare type values.

  static void compareBy(int);                   // Set compare policy.
  static int  compareBy();                      // Get compare policy.

private:
  int        _key;                              // Key value.
  CmObject  *_object;                           // Object pointer.
  static int _compareBy;                        // Compare policy.
};

// "key" returns the key value.
inline int CmObjectReference::key() const
{ return _key; }

// "object" returns the object pointer.
inline CmObject* CmObjectReference::object() const
{ return _object; }

#endif
