// CmDeque.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Deque (double ended queue) definition.
// -----------------------------------------------------------------

#ifndef _CMDEQUE_H
#define _CMDEQUE_H

#include <cm/include/cmlist.h>

class CmDeque : public CmLinkedList {       // Deque class definition.
public:
  CmDeque();                                // Default deque constructor.
  CmDeque(const CmDeque&);                  // Deque copy constructor.
 ~CmDeque() {}                              // Deque destructor.

  CmDeque& operator=(const CmDeque&);       // Assignment operator.

  Bool      pushLeft (CmObject*);           // Push object into queue left.
  Bool      pushRight(CmObject*);           // Push object into queue right.
  CmObject* popLeft  ();                    // Pop and return from queue left.
  CmObject* popRight ();                    // Pop and return from queue right.
  CmObject* peekLeft () const;              // Return pointer to left object.
  CmObject* peekRight() const;              // Return pointer to right object.

  CMOBJECT_DEFINE(CmDeque, CmLinkedList)    // Define object funcs.
};

#endif
