// CmDefs.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Definitions used throughout the Compendium library.
// -----------------------------------------------------------------

#ifndef _CMDEFS_H
#define _CMDEFS_H

#ifndef NULL
#define NULL 0
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef Bool
#define Bool int
#endif

// "CmAbs" absolute value template function.
template<class T> T CmAbs(const T& data)
{ return (data >= 0) ? data : -data; }

// "CmMax" maximum value template function.
template<class T> T CmMax(const T& a, const T& b)
{ return (a >= b) ? a : b; }

// "CmMin" minimum value template function.
template<class T> T CmMin(const T& a, const T& b)
{ return (a <= b) ? a : b; }

#endif
