// taverage.cpp
//
// Example program uses the array template.  The program reads in a set
// of test scores with values between 0 and 100, stuffs each one into an
// array, and then gets the average score which is then printed to standard
// output.  This example is the template version of "average.cxx".  Using
// a template really gets rid of the need for the integer class.
//
#include <iostream.h>
#include <cm/include/cmtarray.h>

const int MIN = 0;                               // Define minimum and
const int MAX = 100;                             // maximum score constants.

int main()                                       // Start main.
{
  CmTArray<int> array;                           // Declare array.
  int           howMany;                         // Number of scores.
  int           input;                           // Input score.

  cout << "How many scores will you enter: " << flush;
  cin  >> howMany;                               // Read in number of scores.
  array.resize(howMany);                         // Set array size.

  int ii = 0;                                    // Loop counter.
  while (ii < howMany)                           // While still in range,
  {
    cout << "Score " << ++ii << ": " << flush;
    cin  >> input;                               // read score.
    if (input < MIN || input > MAX)              // Check score range.
    {
      cout << "Score must be between " << MIN << // Bad range.
              "and " << MAX << endl; ii--;
    }
    else
      array.add(input);                          // Copy score into array.
  }

  CmTArrayIterator<int> iterator(array);         // Create an iterator.
  int                   average = 0;             // Start total at zero.
  while (iterator)                               // While still iterating,
    average += iterator++;                       // add score to total.
                                                 // Print average.
  cout << "\nAverage score is " << average / howMany << ".\n";
  return 0;
}
