// strin.cpp
//
// Example program uses the string class and the binary tree class.
// Strings are read one at a time and inserted into the binary tree
// until an 'x' (exit) is typed.  An iterator is then created and
// used to cycle through the tree printing each object.

#include <cm/include/cmbintr.h>
#include <cm/include/cmstring.h>

int main()                                    // Start main.
{
  CmBinaryTree tree;                          // Binary tree container.
  CmString     input;                         // Input string.
  Bool         finished = FALSE;              // Boolean data type.

  while (!finished)                           // While boolean is true,
  {
    cout << "Enter string (\"x\" when done): " << flush;
    cin  >> input;                            // Read string input.

    int lnth = input.length();                // Get string length.
    if (lnth == 1 && input[0] == 'x')         // If "x" then finished.
      finished = TRUE;

    else if (lnth > 0)                        // Add string to tree.
      tree.add(new CmString(input));
  }

  CmBinaryTreeIterator iterator(tree);        // Create an iterator.
  while (iterator)                            // While iterator is ok,
    cout << *iterator++ << endl;              // print each object.
  return 0;
}
