// lookup.cpp
//
// Example program uses the string class and the btree dictionary class.
// Compendium class names and descriptions of these classes are inserted
// as key/value pairs into the dictionary.  If the program is run with no
// command line arguments, the entires contents of the dictionary are
// printed to the screen.  If a command line argument is typed, it is
// assumed to be a class name.  A "lookup" is performed to find the
// equivalent class name in the dictionary and, if found, that class
// name and it's description is printed to the screen.

#include <cm/include/cmbdict.h>
#include <cm/include/cmstring.h>

// Prototype print function.
void printDictionary(const CmBTreeDictionary&);

const int TOTAL_CLASSES = 23;                   // Define number of strings.

char *classnames[TOTAL_CLASSES] =               // Class name strings.
{ "CmArray",
  "CmAssociation",
  "CmBag",
  "CmBTreeDictionary",
  "CmBinaryTree",
  "CmBTree",
  "CmContainer",
  "CmDate",
  "CmDeque",
  "CmHashTable",
  "CmHashDictionary",
  "CmLinkedList",
  "CmObject",
  "CmOrderedArray",
  "CmQueue",
  "CmReserve",
  "CmReserveFile",
  "CmRing",
  "CmSet",
  "CmStack",
  "CmString",
  "CmTime",
  "CmTokens" };

char *descriptions[TOTAL_CLASSES] =             // Class description strings.
{ "One dimensional array class.",
  "Key/data class used for dictionaries.",
  "Bag class implemented as a hash table.",
  "Balanced tree of associations.",
  "Binary tree class.",
  "Balanced tree class.",
  "Base class for all object based containers.",
  "Date class.",
  "Double ended queue class.",
  "Hash table class.",
  "Hash table of associations.",
  "Singly linked list class.",
  "Abstract base class for all objects.",
  "One dimensional sorted array class.",
  "Queue class implemented as linked list.",
  "File I/O management class.",
  "Binary file interface class.",
  "Circularly linked list class.",
  "Set class implemented as hash table.",
  "Stack class implemented as linked list.",
  "Fully implemented string class.",
  "Time of day class.",
  "String tokenizer class." };

int main(int argc, char *argv[])                // Start main.
{
  CmBTreeDictionary classes;                    // Declare dictionary.

  for (int ii = 0; ii < TOTAL_CLASSES; ii++)    // Stuff with strings.
    classes.add(new CmString(classnames[ii]), new CmString(descriptions[ii]));

  if (argc != 2)                                // If no argument,
    printDictionary(classes);                   // print whole list.
  else                                          // Otherwise, use argument
  {                                             // as key and lookup.
    CmString       key(argv[1]);
    CmAssociation *found = (CmAssociation*) classes.lookupAssoc(&key);

    if (found)
      cout << *(found->key()) << " - " << *(found->object()) << endl;
    else
      cout << "Class " << argv[1] << " not in dictionary." << endl;
  }
  return 0;
}

void printDictionary(const CmBTreeDictionary& dict) // Print function.
{
  cout << "Compendium Container Class Library Object-Based Class List." << endl;
  CmBTreeIterator iterator(dict);                   // Create an iterator.
  while (iterator)                                  // While still alive,
  {                                                 // print associations.
    CmAssociation* pAssoc = (CmAssociation*) iterator++;
    cout << *(pAssoc->key()) << " - " << *(pAssoc->object()) << endl;
  }
}
