// integer.h
//
// Example class definition.  This simple integer class is derived
// from the abstract class "CmObject".  All of the virtual functions
// in the base class are redefined and some simple lexical operators
// are also defined making this class usable with both the object
// and template based containers.
//
#ifndef INTEGER_H
#define INTEGER_H

#include <cm/include/cmobject.h>

class Integer : public CmObject {          // Integer class definition.
public:
  Integer(int v = 0) : _value(v) {}        // Default integer constructor.

  operator int() const;                    // Type conversion operator.

  void value(int);                         // Set new integer value.
  int  value() const;                      // Return integer value.

  CMOBJECT_DEFINE(Integer, CmObject)       // Define base. (A MUST!!)

  Bool     isEqual (CmObject*) const;      // Compare objects.
  int      compare (CmObject*) const;      // Compare objects.
  unsigned hash    (unsigned)  const;      // Hash function.
  void     printOn (ostream&)  const;      // Print to stream.
  void     readFrom(istream&);             // Read from stream.
  Bool     write   (CmReserveFile&) const; // Write to reserve file.
  Bool     read    (CmReserveFile&);       // Read from reserve file.

  Bool operator< (const Integer&) const;   // Is this <  input?
  Bool operator<=(const Integer&) const;   // Is this <= input?
  Bool operator> (const Integer&) const;   // Is this >  input?
  Bool operator>=(const Integer&) const;   // Is this >= input?
  Bool operator==(const Integer&) const;   // Is this == input?
  Bool operator!=(const Integer&) const;   // Is this != input?

private:
  int _value;                              // Integer value.
};

// "int" type conversion operator returns the integer value.
inline Integer::operator int() const
{ return _value; }

// "value" sets a new integer value.
inline void Integer::value(int v)
{ _value = v; }

// "value" returns the integer value.
inline int Integer::value() const
{ return _value; }

#endif
