// integer.cpp
//
// Example class implementation.  This file contains the implementations
// of the non inline functions contained in the example Integer class.
// Notice, in the first two functions, that we always check the type
// before casting.  Since the object based containers can hold mixed
// types, this is a very good practice to get into.  Also notice the
// I/O function implementations.  These functions make this class usable
// with the C++ stream operators as well as the reserve class.
//
#include "integer.h"

// "isEqual" returns TRUE if the input object is of type "Integer"
// and if it's integer value is the same as this integer value.
//
Bool Integer::isEqual(CmObject* pObj) const
{
  if (!pObj->isA("Integer")) return FALSE;       // A MUST!!!
  return (((Integer*) pObj)->_value == _value);
}

// "compare" returns FALSE if the input object is not of type
// "Integer".  If it is, "compare" returns 0 if the integer values
// are equal, -1 if this integer value is less than the input, and
// 1 if this integer value is greater than the input.
//
int Integer::compare(CmObject* pObj) const
{
  if (!pObj->isA("Integer")) return FALSE;       // A MUST!!!
  int val = ((Integer*) pObj)->_value;
  return ((_value == val) ? 0 : ((_value > val) ? 1 : -1));
}

// "hash" is the hash function for the integer value.  A mod is
// performed with the value and the input table size.
//
unsigned Integer::hash(unsigned size) const
{
  return (unsigned)(_value % size);
}

// "printOn" prints the integer value on the specified output
// stream.
//
void Integer::printOn(ostream& os)  const
{
  os << _value;
}

// "readFrom" reads the integer value from the specified input
// stream.
//
void Integer::readFrom(istream& is)
{
  is >> _value;
}

// "write" writes the integer value to the specified file.
//
Bool Integer::write(CmReserveFile& file) const
{
  return file.write(_value);
}

// "read" reads the integer value from the specified file.
//
Bool Integer::read(CmReserveFile& file)
{
  return file.read(_value);
}

// "<" operator returns TRUE if this integer is less than the
// specified integer.
//
Bool Integer::operator<(const Integer& rInt) const
{
  return (_value < rInt._value);
}

// "<=" operator returns TRUE if this integer is less than or
// equal to specified integer.
//
Bool Integer::operator<=(const Integer& rInt) const
{
  return (_value <= rInt._value);
}

// ">" operator returns TRUE if this integer is greater than the
// specified integer.
//
Bool Integer::operator>(const Integer& rInt) const
{
  return (_value > rInt._value);
}

// ">=" operator returns TRUE if this integer is greater than or
// equal to specified integer.
//
Bool Integer::operator>=(const Integer& rInt) const
{
  return (_value >= rInt._value);
}

// "==" operator returns TRUE if this integer is equal to the
// specified integer.
//
Bool Integer::operator==(const Integer& rInt) const
{
  return (_value == rInt._value);
}

// "!=" operator returns TRUE if this integer is not equal to the
// specified integer.
//
Bool Integer::operator!=(const Integer& rInt) const
{
  return (_value != rInt._value);
}
