// avres.cpp
//
// Example program show use of the class "CmReserve".  This program
// prompts for names and test scores (between 0 and 100) until an "x"
// (exit) is typed for a name.  The scores are then printed to the
// screen along with the average score.  Both the name list and the
// score list are then written to a binary file using the reserve's
// "write" functions.  All subsequent runs of this program start by
// first reading this file using the reserve's "read" function.  The
// name list and score list are printed to the screen and then the
// user is prompted for names and scores to add to the existing list.
//
#include <stdio.h>
#include <cm/include/cmstring.h>
#include <cm/include/cmreserv.h>
#include "integer.h"

const char*   RESERVENAME = "AVRES.DAT";         // Reserve file name.
const char*   RESERVEID   = "RESERVE EXAMPLE";   // Reserve identifier.
const Integer min(0);                            // Minimum score value.
const Integer max(100);                          // Maximum score value.

void printReserve();                             // Reserve output func.

CmContainer *nameRoot, *scorRoot;                // Root container ptrs.

int main()                                       // Start main.
{
  CmReserve::initialize   ();                    // Register Cm classes.
  CmReserve::registerClass(new Integer);         // Register integer class.

  CmReserve reserve(RESERVENAME);                // Declare the reserve.
  reserve.identifier(RESERVEID);                 // Set the identifier.

  if (reserve.exists() && reserve.read())        // Read the reserve.
  {
    nameRoot = reserve["NAMES"];                 // Get names root.
    scorRoot = reserve["SCORES"];                // Get scores root.
    printReserve();                              // Print the reserve.
  }
  else                                           // Reserve is new.
  {
    nameRoot = reserve.createRoot("NAMES");      // Create names root.
    scorRoot = reserve.createRoot("SCORES");     // Create scores root.
  }

  Bool     done = FALSE;
  CmString name, cscore;
  int      score;

  while (!done)                                  // While getting input,
  {
    cout << "Enter name (\"x\" when done): " << flush; // Read name.
    cin  >> name;
    if (name[0] == 'x')                          // 'x' = time to exit.
    {
      printReserve();                            // Print the reserve.
      reserve.write();                           // Write the reserve.
      done = TRUE;                               // Finished.
    }

    else                                         // Got a name.
    {
      cout << "Enter score               : " << flush; // Read the score.
      cin  >> cscore;
      sscanf((const char*) cscore, "%d", &score);

      if (score < (int) min || score > (int) max)  // Out of range.
        cout << "Score must be between " << min << "and " << max << endl;
      else
      {
        nameRoot->add(new CmString(name));       // Add name to root.
        scorRoot->add(new Integer(score));       // Add score to root.
      }
    }
  }
  return 0;
}

void printReserve()                              // Reserve print function.
{
  cout << endl << "Reserve contents (name, score):" << endl;
  CmIterator *iterator1 = nameRoot->newIterator();  // Use "newIterator"
  CmIterator *iterator2 = scorRoot->newIterator();
  int         average   = 0;
  int         total     = 0;
  while (!iterator1->done() && !iterator2->done())
  {
    Integer* pInt = (Integer*) iterator2->next();
    cout << *(iterator1->next()) << " - " << *pInt << endl;
    average += (int) (*pInt); total++;
  }
  cout << "--------------------" << endl;
  cout << "Average score is " << average / total << "." << endl;
  delete iterator1;          // Must delete the iterators.
  delete iterator2;
}
