// CmStack.cpp
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Stack implementation.
// -----------------------------------------------------------------

#include <cm/include/cmstack.h>


// "CmStack" is the default stack constructor.
//
CmStack::CmStack() : CmLinkedList()
{}


// "CmStack" is the stack copy constructor.
//
CmStack::CmStack(const CmStack& St) : CmLinkedList(St)
{}


// "=" assignment operator copies the specified stack into this stack.
//
CmStack& CmStack::operator=(const CmStack& St)
{
  return (CmStack&) CmLinkedList::operator=(St);
}


// "push" places the specified object on top of the stack.
//
Bool CmStack::push(CmObject* pObj)
{
  return prepend(pObj);
}


// "pop" pops the top object off of the stack and returns it.
//
CmObject* CmStack::pop()
{
  return removeFirst();
}


// "peek" returns a pointer to the top object on the stack leaving the
// object in place.
// 
CmObject* CmStack::peek() const
{
  return first();
}
