// CmObjRef.cpp
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Object reference implementation used internally by the reserve.
// -----------------------------------------------------------------

#include <cm/include/cmobjref.h>


// Initialize the compare policy value.
//
int CmObjectReference::_compareBy = CmObjectReference::OBJECTS;


// "CmObjectReference" is a reference constructor.
//
CmObjectReference::CmObjectReference(int k) : _key(k), _object(NULL)
{}


// "CmObjectReference" is a reference constructor.
//
CmObjectReference::CmObjectReference(CmObject* o) : _key(0), _object(o)
{}


// "CmObjectReference" is a reference constructor.
//
CmObjectReference::CmObjectReference(int k, CmObject* o)
                 : _key(k), _object(o)
{}


// "isEqual" compares the specified object with this reference using
// the current compare policy.
//
Bool CmObjectReference::isEqual(CmObject* pObj) const
{
  if (!pObj->isA("CmObjectReference")) return CmObject::isEqual(pObj);
  CmObjectReference *pRef = (CmObjectReference*) pObj;
  if (CmObjectReference::_compareBy == CmObjectReference::KEYS)
    return (_key == pRef->_key) ? TRUE : FALSE;
  else
    return (_object == pRef->_object) ? TRUE : FALSE;
}


// "compare" compares the specified object with this reference using
// the current compare policy.
//
int CmObjectReference::compare(CmObject* pObj) const
{
  if (!pObj->isA("CmObjectReference")) return CmObject::compare(pObj);
  CmObjectReference *pRef = (CmObjectReference*) pObj;
  if (CmObjectReference::_compareBy == CmObjectReference::KEYS)
    return ((_key == pRef->_key) ? 0 : ((_key > pRef->_key) ? 1 : -1));
  else
    return ((_object==pRef->_object) ? 0 : ((_object>pRef->_object) ? 1 : -1));
}


// "hash" performs a hash on the key value or object pointer depending
// on the current compare policy value.
//
unsigned CmObjectReference::hash(unsigned m) const
{
  if (CmObjectReference::_compareBy == CmObjectReference::KEYS)
    return (unsigned) _key % m;
  else
    return (unsigned) _object % m;
}


// "compareBy" sets the compare policy value.
//
void CmObjectReference::compareBy(int cb)
{
  if (cb == CmObjectReference::KEYS || cb == CmObjectReference::OBJECTS)
    CmObjectReference::_compareBy = cb;
}


// "compareBy" returns the current compare policy value.
//
int CmObjectReference::compareBy()
{
  return CmObjectReference::_compareBy;
}
