// CmBag.cpp
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Bag implementation.
// -----------------------------------------------------------------

#include <cm/include/cmbag.h>


// "CmBag" is the default bag constructor.
//
CmBag::CmBag(unsigned sz) : CmHashTable(sz)
{}


// "CmBag" is the bag copy constructor.
//
CmBag::CmBag(const CmBag& B) : CmHashTable(B)
{}


// "=" assignment operator copies the contents of the specified
// bag into this bag.
//
CmBag& CmBag::operator=(const CmBag& B)
{
  return (CmBag&) CmHashTable::operator=(B);
}
