// CmTVec.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Dynamic array template implementation.
// -----------------------------------------------------------------


// "CmTVector" is the default vector constructor.
//
template <class T> CmTVector<T>::CmTVector(unsigned sz)
{
  _array = (sz > 0) ? new T[sz] : NULL;
  _size  = (_array) ? sz : 0;
}


// "CmTVector" is the vector copy constructor.
//
template <class T> CmTVector<T>::CmTVector(const CmTVector<T>& aVec)
{
  _size  = 0;
  _array = NULL;
  copy(aVec);
}


// "~CmTVector" is the vector destructor.
//
template <class T> CmTVector<T>::~CmTVector()
{
  clear();
}


// "=" assignment operator copies the contents from an input array into
// this array.
//
template <class T>
CmTVector<T>& CmTVector<T>::operator=(const CmTVector<T>& aVec)
{
  if (&aVec != this) copy(aVec);
  return *this;
}


// "size" returns the vector size.
//
template <class T> unsigned CmTVector<T>::size() const
{
  return _size;
}


// "array" returns the array pointer in the vector.
//
template <class T> T* CmTVector<T>::array() const
{
  return _array;
}


// "[]" operator returns the entry at the specified index in the array.
//
template <class T> T& CmTVector<T>::operator[](int idx)
{
  if (idx < 0) idx = 0;
  if (idx >= _size)
    if (!resize(idx + 1)) idx = _size;
  return _array[idx];
}


// "[]" operator returns the entry at the specified index in the array.
//
template <class T> const T& CmTVector<T>::operator[](int idx) const
{
  if (idx < 0) idx = 0;
  if (idx >= _size)
    if (!((CmTVector<T>*) this)->resize(idx + 1)) idx = _size;
  return _array[idx];
}


// "clear" clears out this array resetting the size to zero.
//
template <class T> void CmTVector<T>::clear()
{
  delete[] _array;
  _size  = 0;
  _array = NULL;
}


// "resize" resizes the array to match a specified size.
//
template <class T> Bool CmTVector<T>::resize(unsigned NewSize)
{
  if (NewSize == 0)                    // Zero size specified.
    clear();
  else                                 // Specified size is greater than zero.
  {                                    // Create new list and copy old one
    T *newentries = new T[NewSize];    // into it.  Delete the old.
    if (!newentries) return FALSE;
    if (_size > 0)
    {
      unsigned limit = (_size > NewSize) ? NewSize : _size;
      for (int ii = 0; ii < limit; ii++)
        newentries[ii] = _array[ii];
      delete[] _array;
    }
    _size  = NewSize;
    _array = newentries;
  }
  return TRUE;
}


// "copy" copies the contents of an input vector into this vector.
//
template <class T> void CmTVector<T>::copy(const CmTVector<T>& aVec)
{
  if (_array) delete[] _array;
  _array = NULL;
  _size  = aVec._size;
  if (aVec._array)
  {
    _array = new T[_size];
    for (int ii = 0; ii < _size; ii++)
      _array[ii] = aVec._array[ii];
  }
}
