// CmTStack.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Stack template definition.
// -----------------------------------------------------------------

#ifndef _CMTSTACK_H
#define _CMTSTACK_H

#include <cm/include/cmtlist.h>

template <class T> class CmTStack : public CmTLinkedList<T> {
public:
  CmTStack() {}                                 // Default stack constructor.
  CmTStack(const CmTStack<T>&);                 // Stack copy constructor.
 ~CmTStack() {}                                 // Stack destructor.

  CmTStack<T>& operator=(const CmTStack<T>&);   // Assignment operator.

  Bool     push (const T&);                     // Push item onto stack.
  T        pop  ();                             // Pop top item from stack.
  const T& peek () const;                       // Return copy of top item.
};

#if defined(__TURBOC__) || defined(__xlC__)
#include <cm/include/cmtstack.cc>
#endif

#endif
