// CmTStack.cc
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Stack template implementation.
// -----------------------------------------------------------------


// "CmTStack" is the stack copy constructor.
//
template <class T> CmTStack<T>::CmTStack(const CmTStack<T>& S)
                                : CmTLinkedList<T>(S)
{}


// "=" operator copies the contents of the input stack into this stack.
//
template <class T> CmTStack<T>& CmTStack<T>::operator=(const CmTStack<T>& S)
{
  if (&S != this) copy(S);
  return *this;
}


// "push" pushes the specified item onto the top of the stack.
//
template <class T> Bool CmTStack<T>::push(const T& obj)
{
  return prepend(obj);
}


// "pop" removes the top item from the stack and returns a copy.
//
template <class T> T CmTStack<T>::pop()
{
  return removeFirst();
}


// "peek" returns a copy of the top stack item.
//
template <class T> const T& CmTStack<T>::peek() const
{
  return first();
}
