// CmTQueue.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Queue template definition.
// -----------------------------------------------------------------

#ifndef _CMTQUEUE_H
#define _CMTQUEUE_H

#include <cm/include/cmtlist.h>

template <class T> class CmTQueue : public CmTLinkedList<T> {
public:
  CmTQueue() {}                                 // Default queue constructor.
  CmTQueue(const CmTQueue<T>&);                 // Queue copy constructor.
 ~CmTQueue() {}                                 // Queue destructor.

  CmTQueue<T>& operator=(const CmTQueue<T>&);   // Assignment operator.

  Bool     push (const T&);                     // Push item into queue.
  T        pop  ();                             // Pop front item from queue.
  const T& peek () const;                       // Return copy of front item.
};

#if defined(__TURBOC__) || defined(__xlC__)
#include <cm/include/cmtqueue.cc>
#endif

#endif
