// CmTQueue.cc
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Queue template implementation.
// -----------------------------------------------------------------


// "CmTQueue" is the queue copy constructor.
//
template <class T> CmTQueue<T>::CmTQueue(const CmTQueue<T>& S)
                                : CmTLinkedList<T>(S)
{}


// "=" operator copies the contents of the input queue into this queue.
//
template <class T> CmTQueue<T>& CmTQueue<T>::operator=(const CmTQueue<T>& S)
{
  if (&S != this) copy(S);
  return *this;
}


// "push" pushes the specified item onto the top of the queue.
//
template <class T> Bool CmTQueue<T>::push(const T& obj)
{
  return append(obj);
}


// "pop" removes the top item from the queue and returns a copy.
//
template <class T> T CmTQueue<T>::pop()
{
  return removeFirst();
}


// "peek" returns a copy of the top queue item.
//
template <class T> const T& CmTQueue<T>::peek() const
{
  return first();
}
