// CmTokens.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// String tokenizer definition.
// -----------------------------------------------------------------

#ifndef _CMTOKENS_H
#define _CMTOKENS_H

#include <cm/include/cmstring.h>

class CmTokens : public CmObject {          // Tokenizer class definition.
public:
  CmTokens(const char*);                    // Tokenizer constructor.
  CmTokens(const CmTokens&);                // Tokenizer copy constructor.

  CmTokens& operator=(const CmTokens&);     // Assignment operator.

  const char* next (const char* = "\n");    // Get next token.
  void        reset();                      // Reset to start of string.

  Bool     isEqual (CmObject*) const;       // Compare tokenizer strings.
  int      compare (CmObject*) const;       // Compare tokenizer strings.
  unsigned hash    (unsigned)  const;       // Hash tokenizer string.
  void     printOn (ostream&)  const;       // Print tokenizer string.

  CMOBJECT_DEFINE(CmTokens, CmObject)       // Define object funcs.

private:
  CmString    _string;                      // String to tokenize.
  const char *_place;                       // Place holder.
  int         _idx;                         // Place holder index.
};

#endif
