// CmTIter.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Abstract container iterator template definition.
// -----------------------------------------------------------------

#ifndef _CMTITER_H
#define _CMTITER_H

#include <cm/include/cmdefs.h>

template <class T> class CmTIterator {          // Iterator class definition.
public:
  virtual Bool     done    () const = 0;        // Check if end of container.
  virtual const T& next    ()       = 0;        // Return and advance.
  virtual const T& previous()       = 0;        // Return and backup.
  virtual const T& current () const = 0;        // Return current object.
  virtual void     first   ()       = 0;        // Move to first object.
  virtual void     last    ()       = 0;        // Move to last object.

  const T& nextOccurrence    (const T&);        // Advance to next equal.
  const T& previousOccurrence(const T&);        // Backup to previous equal.

  operator int() const;                         // Check if not end.

  const T& operator++();                        // Advance and return.
  const T& operator++(int);                     // Return and advance.
  const T& operator+=(int);                     // Advance n places.
  const T& operator--();                        // Backup and return.
  const T& operator--(int);                     // Return and backup.
  const T& operator-=(int);                     // Backup n places.
  const T& operator()() const;                  // Return current object.
};

#if defined(__TURBOC__) || defined(__xlC__)
#include <cm/include/cmtiter.cc>
#endif

#endif
