// CmTHDict.cc
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Hash dictionary template implementation.
// -----------------------------------------------------------------


// "CmTHashDictionary" is the default dictionary constructor.
//
template <class T, class O>
CmTHashDictionary<T,O>::CmTHashDictionary(unsigned order)
                      : CmTHashTable< CmTAssociation<T, O> >(order)
{}


// "CmTHashDictionary" is the dictionary copy constructor.
//
template <class T, class O>
CmTHashDictionary<T,O>::CmTHashDictionary(const CmTHashDictionary<T,O>& Tr)
                      : CmTHashTable< CmTAssociation<T, O> >(Tr)
{}


// "=" assignment operator copies the specified dictionary into this
// dictionary.
//
template <class T, class O> CmTHashDictionary<T,O>&
CmTHashDictionary<T,O>::operator=(const CmTHashDictionary<T,O>& Tr)
{
  return (CmTHashDictionary<T,O>&)
          CmTHashTable< CmTAssociation<T, O> >::operator=(Tr);
}


// "addKey" adds an association with the specified key to the dictionary.
//
template <class T, class O>
Bool CmTHashDictionary<T,O>::addKey(const T& rKey)
{
  return add(CmTAssociation<T,O>(rKey));
}


// "addKeyAndObject" adds an association with the specified key and the
// specified object to the dictionary.
//
template <class T, class O>
Bool CmTHashDictionary<T,O>::addKeyAndObject(const T& rKey, const O& rObj)
{
  return add(CmTAssociation<T,O>(rKey, rObj));
}


// "addAssoc" adds the specified association to the dictionary.
//
template <class T, class O>
Bool CmTHashDictionary<T,O>::addAssoc(const CmTAssociation<T,O>& rAssoc)
{
  return add(rAssoc);
}


// "removeKey" removes the first association containing the specified
// key from the dictionary.
//
template <class T, class O>
Bool CmTHashDictionary<T,O>::removeKey(const T& rKey)
{
  return remove(CmTAssociation<T,O>(rKey));
}


// "lookupKey" returns a copy of the key out of the first occurrence of
// an association containing the specified key.
//
template <class T, class O>
const T& CmTHashDictionary<T,O>::lookupKey(const T& rKey) const
{
  const CmTAssociation<T,O>& assoc = lookup(CmTAssociation<T,O>(rKey));
  return assoc.key();
}


// "lookupObject" returns a copy of the object out of the first occurrence
// of an association containing the specified key.
//
template <class T, class O>
const O& CmTHashDictionary<T,O>::lookupObject(const T& rKey) const
{
  const CmTAssociation<T,O>& assoc = lookup(CmTAssociation<T,O>(rKey));
  return assoc.object();
}


// "lookupAssoc" returns a copy of the first occurrence of an association
// containing the specified key.
//
template <class T, class O> const CmTAssociation<T,O>&
CmTHashDictionary<T,O>::lookupAssoc(const T& rKey) const
{
  return lookup(CmTAssociation<T,O>(rKey));
}


// "replace" finds the first occurrence of an association containing the
// specified key and replaces the object value.
//
template <class T, class O>
Bool CmTHashDictionary<T,O>::replace(const T& rKey, const O& rObj)
{
  if (remove(CmTAssociation<T,O>(rKey)))
    return addKeyAndObject(rKey, rObj);
  else
    return FALSE;
}


// "containsKey" returns TRUE if the dictionary contains an association
// with the specified key.
//
template <class T, class O>
Bool CmTHashDictionary<T,O>::containsKey(const T& rKey) const
{
  return contains(CmTAssociation<T,O>(rKey));
}


// "occurrencesOfKey" returns the number of associations containing
// the specified key.
//
template <class T, class O>
unsigned CmTHashDictionary<T,O>::occurrencesOfKey(const T& rKey) const
{
  return occurrences(CmTAssociation<T,O>(rKey));
}
