// CmTDeque.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Deque (double ended queue) template definition.
// -----------------------------------------------------------------

#ifndef _CMTDEQUE_H
#define _CMTDEQUE_H

#include <cm/include/cmtlist.h>

template <class T> class CmTDeque : public CmTLinkedList<T> {
public:
  CmTDeque() {}                                 // Default deque constructor.
  CmTDeque(const CmTDeque<T>&);                 // Deque copy constructor.
 ~CmTDeque() {}                                 // Deque destructor.

  CmTDeque<T>& operator=(const CmTDeque<T>&);   // Assignment operator.

  Bool     pushLeft (const T&);                 // Push item into queue left.
  Bool     pushRight(const T&);                 // Push item into queue right.
  T        popLeft  ();                         // Pop item from queue left.
  T        popRight ();                         // Pop item from queue right.
  const T& peekLeft () const;                   // Return copy of left item.
  const T& peekRight() const;                   // Return copy of right item.
};

#if defined(__TURBOC__) || defined(__xlC__)
#include <cm/include/cmtdeque.cc>
#endif

#endif
