// CmTCont.cc
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Abstract container template implementation.
// -----------------------------------------------------------------


// "CmTContainer" is the container copy constructor.
//
template <class T> CmTContainer<T>::CmTContainer(const CmTContainer<T>&)
                                  : _error(* new T)
{}


// "~CmTContainer" is the container destructor.
//
template <class T> CmTContainer<T>::~CmTContainer()
{
  delete &_error;
}


// "[]" indexing operator returns the item at the specified index.
//
template <class T> const T& CmTContainer<T>::operator[](int idx) const
{
  if (idx < 0 || idx >= size()) return _error;
  CmTIterator<T> *iterator = newIterator();
  int             ii       = 0;
  const T*        out;

  while (!iterator->done() && ii <= idx)
  {
    if (ii++ == idx) out = & iterator->current();
    iterator->next();
  }
  delete iterator;
  return *out;
}


// "size" returns the current container size.
//
template <class T> int CmTContainer<T>::size() const
{
  return _size;
}


// "isEmpty" returns TRUE if the container is empty.
//
template <class T> Bool CmTContainer<T>::isEmpty() const
{
  return (_size == 0);
}


// "copy" copies the contents of the specified container into
// this container.
//
template <class T> void CmTContainer<T>::copy(const CmTContainer<T>& C)
{
  _size = C._size;
  CmTIterator<T> *iterator = C.newIterator();
  while (!iterator->done()) add(iterator->next());
  delete iterator;
}
