// CmTBag.cc
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Bag template implementation.
// -----------------------------------------------------------------


// "CmTBag" is the default bag constructor.
//
template <class T> CmTBag<T>::CmTBag(unsigned sz)
                            : CmTHashTable<T>(sz)
{}


// "CmTBag" is the bag copy constructor.
//
template <class T> CmTBag<T>::CmTBag(const CmTBag<T>& B)
                            : CmTHashTable<T>(B)
{}


// "=" assignment operator copies the specified bag into this bag.
//
template <class T> CmTBag<T>& CmTBag<T>::operator=(const CmTBag<T>& B)
{
  return (CmTBag<T>&) CmTHashTable<T>::operator=(B);
}
