// CmHDict.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Hash dictionary definition.
// -----------------------------------------------------------------

#ifndef _CMHDICT_H
#define _CMHDICT_H

#include <cm/include/cmhash.h>
#include <cm/include/cmassoc.h>

class CmHashDictionary : public CmHashTable {         // Dictionary definition.
public:
  CmHashDictionary(unsigned = 10);                    // Default constructor.
  CmHashDictionary(const CmHashDictionary&);          // Copy constructor.
 ~CmHashDictionary();                                 // Destructor.

  CmHashDictionary& operator=(const CmHashDictionary&); // Assignment operator.

  Bool           add         (CmObject*);             // Add association.
  Bool           add         (CmObject*, CmObject*);  // Add key and object.
  CmObject*      lookup      (CmObject*) const;       // Key from key.
  CmObject*      lookupObject(CmObject*) const;       // Object from key.
  CmAssociation* lookupAssoc (CmObject*) const;       // Association from key.
  Bool           replace     (CmObject*, CmObject*);  // Replace object at key.
  Bool           remove      (CmObject*);             // Remove key and object.
  Bool           contains    (CmObject*) const;       // Key in dictionary?
  unsigned       occurrences (CmObject*) const;       // Occurrences of key.
  void           removeAll   ();                      // Remove all objects.

  CMOBJECT_DEFINE(CmHashDictionary, CmHashTable)      // Define object funcs.
};

#endif
