// CmBDict.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// BTree dictionary definition.
// -----------------------------------------------------------------

#ifndef _CMBDICT_H
#define _CMBDICT_H

#include <cm/include/cmbtree.h>
#include <cm/include/cmassoc.h>

class CmBTreeDictionary : public CmBTree {            // Dictionary definition.
public:
  CmBTreeDictionary(unsigned = 10);                   // Default constructor.
  CmBTreeDictionary(const CmBTreeDictionary&);        // Copy constructor.
 ~CmBTreeDictionary();                                // Destructor.

  CmBTreeDictionary& operator=(const CmBTreeDictionary&); // Assignment op.

  Bool           add         (CmObject*);             // Add association.
  Bool           add         (CmObject*, CmObject*);  // Add key and object.
  CmObject*      lookup      (CmObject*) const;       // Key from key.
  CmObject*      lookupObject(CmObject*) const;       // Object from key.
  CmAssociation* lookupAssoc (CmObject*) const;       // Association from key.
  Bool           replace     (CmObject*, CmObject*);  // Replace object at key.
  Bool           remove      (CmObject*);             // Remove key and object.
  Bool           contains    (CmObject*) const;       // Key in dictionary?
  unsigned       occurrences (CmObject*) const;       // Occurrences of key.
  void           removeAll   ();                      // Remove all objects.

  CMOBJECT_DEFINE(CmBTreeDictionary, CmBTree)         // Define object funcs.
};

#endif
