// CmAssoc.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Association definition.
// -----------------------------------------------------------------

#ifndef _CMASSOC_H
#define _CMASSOC_H

#include <cm/include/cmobject.h>

class CmAssociation : public CmObject {           // Association definition.
public:
  CmAssociation(CmObject*, CmObject*);            // Association constructor.
  CmAssociation(const CmAssociation&);            // Copy constructor.
 ~CmAssociation() {}                              // Association destructor.

  CmAssociation& operator=(const CmAssociation&); // Assignment operator.

  CmObject* key   () const;                       // Key access.
  CmObject* object() const;                       // Object access.
  void      object(CmObject* O);                  // Set object.

  Bool     isEqual(CmObject*) const;              // Compare objects.
  int      compare(CmObject*) const;              // Compare objects.
  unsigned hash   (unsigned)  const;              // Hash function.
  void     printOn(ostream&)  const;              // Print on stream.
  Bool     write  (CmReserveFile&) const;         // Write to reserve file.
  Bool     read   (CmReserveFile&);               // Read from reserve file.

  CMOBJECT_DEFINE(CmAssociation, CmObject)        // Define object funcs.

protected:
  CmObject *_key;                                 // Association key.
  CmObject *_object;                              // Association object.
};

// "key" returns the key value.
inline CmObject* CmAssociation::key() const
{ return _key; }

// "object" returns the object value.
inline CmObject* CmAssociation::object() const
{ return _object; }

// "object" sets a new object value.
inline void CmAssociation::object(CmObject* O)
{ _object = O; }

#endif
