// tstrin.cpp
//
// Example program uses the string class and the binary tree template.
// Strings are read one at a time and inserted into the tree template
// until an 'x' (exit) is typed.  An iterator template is then created
// and used to cycle through the tree printing each item.

#include <cm/include/cmtbintr.h>
#include <cm/include/cmstring.h>

int main()                                    // Start main.
{
  CmTBinaryTree<CmString> tree;               // Binary tree template.
  CmString                input;              // Input string.
  Bool                    finished = FALSE;   // Boolean data type.

  while (!finished)                           // While boolean is true,
  {
    cout << "Enter string (\"x\" when done): " << flush;
    cin  >> input;                            // Read string input.

    int lnth = input.length();                // Get string length.
    if (lnth == 1 && input[0] == 'x')         // If "x" then finished.
      finished = TRUE;

    else if (lnth > 0)                        // Add string to tree.
      tree.add(input);                        // String is copied.
  }

  CmTBinaryTreeIterator<CmString> iterator(tree); // Iterator template.
  while (iterator)                            // While iterator is ok,
    cout << iterator++ << endl;               // print each item.
  return 0;
}
