// queries.cpp
//
// Example program uses the container query mechanisms.  Strings are
// read in one line at a time and inserted into a linked list until an
// 'x' (exit) is typed.  The list's "forEach" function is used to
// print the strings in the list.  Then the program prompts for a letter.
// The list's "query" function is used to build a sub list containing
// all strings beginning with a letter less than the input letter.
// That sub list is then printed using the sub list's "forEach" function.

#include <cm/include/cmlist.h>
#include <cm/include/cmstring.h>

// Prototype query functions.
Bool printObject(CmObject*, void*);           // Print specified object.
Bool buildSubset(CmObject*, void*);           // Check specified object.

int main()                                    // Start main.
{
  CmLinkedList list;                          // Declare linked list.
  CmString     input;                         // Input string.
  Bool         finished = FALSE;              // Boolean data type.

  while (!finished)                           // While boolean is true.
  {
    cout << "Enter string (\"x\" when done): " << flush;
    cin  >> input;                            // Read string input.

    int lnth = input.length();                // Get string length.
    if (lnth == 1 && input[0] == 'x')         // If "x" then finished.
      finished = TRUE;

    else if (lnth > 0)                        // Add string to tree.
      list.add(new CmString(input));
  }

  list.forEach(printObject, &cout);           // Print strings.
  cout << endl;
                                              // Prompt for string to
  CmString match;                             // use in conditional.
  cout << "Print strings starting with letter less than: " << flush;
  cin  >> match;
                                              // Build the subset.
  CmContainer *subset = list.query(buildSubset, &match);

  subset->forEach(printObject, &cout);        // Print subset.
  delete subset;
  return 0;
}

Bool printObject(CmObject* pObj, void* pData) // Print function.
{
  ostream& os = *((ostream*) pData);          // Cast data to stream.
  os << *pObj << endl;                        // Print object.
  return TRUE;                                // Continue.
}

Bool buildSubset(CmObject* pObj, void* pData) // Condition function.
{
  if (!pObj->isA("CmString")) return FALSE;   // If not string, return.
  CmString &str = *((CmString*) pData);       // Cast data to match string.
  return ((CmString&)(*pObj) < str);          // Return condition.
}
