// average.cpp
//
// Example program uses the array class and the example class defined in
// the file "integer.h".  The program reads in a set of test scores with
// values between 0 and 100, stuffs each one into an array, and then gets
// the average score which is then printed to standard output.  This
// example could be greatly improved by defining mathematical operators
// for the integer class.
//
#include <cm/include/cmarray.h>
#include "integer.h"

const Integer MIN(0);                            // Define minimum and
const Integer MAX(100);                          // maximum score constants.

int main()                                       // Start main.
{
  CmArray array;                                 // Declare array.
  Integer howMany;                               // Number of scores.
  Integer input;                                 // Input score.

  cout << "How many scores will you enter: " << flush;
  cin  >> howMany;                               // Read in number of scores.
  array.resize((int) howMany);                   // Set array size.

  int ii = 0;                                    // Loop counter.
  while (ii < (int) howMany)                     // While still in range,
  {
    cout << "Score " << ++ii << ": " << flush;
    cin  >> input;                               // read score.
    if (input < MIN || input > MAX)              // Check score range.
    {
      cout << "Score must be between " << MIN << // Bad range.
              "and " << MAX << endl; ii--;
    }
    else
      array.add(new Integer(input));             // Add score to array.
  }

  CmArrayIterator iterator(array);               // Create an iterator.
  int             average  = 0;                  // Start total at zero.
  while (iterator)                               // While still iterating,
  {
    Integer *pInt = (Integer*) iterator++;       // Cast to Integer type.
    average += (int)(*pInt);                     // Add to total.
  }
                                                 // Print average.
  cout << "\nAverage score is " << average / (int) howMany << ".\n";
  return 0;
}
