// Exercise 9

// Use the "Date" and "Time" objects to measure the execution time for the
// work of item 1 but, do it with 500 numbers.  Print out the starting date
// and time before the measurement begins, then again at the end, and also
// print out elapsed time difference.

// Comments

// The only tricky part here is to access the members of the Time and
// Date objects (representing the start and finish) in order to calculate
// the difference (elapsed time).  Here we permit a midnight boundary to
// be crossed but assume the process takes less than a day.

#include <stack.h>
#include <ltime.h>
#include <ldate.h>

class Int : public Sortable {
   int   i;
public:
   Int()      { i = 0; }
   Int(int m) { i = m; }

   classType       isA()       const   { return __firstUserClass; }
   char            *nameOf()   const   { return "Int";            }
   hashValueType   hashValue() const   { return hashValueType(i); }

   void            printOn( ostream& o ) const     { o << i;      }

   int isEqual   (const Object& X) const { return i == ((Int&)X).i; }
   int isLessThan(const Object& X) const { return i <  ((Int&)X).i; }

   operator int()  { return i; }
};

int main()
{
   Stack mystack;

   // Default constructors initialize to current date and time
   Date start_date;
   Time start_time;

   // Print starting Date and Time
   cout << "Date: " << start_date << "  Time: " << start_time << endl;

   // Populate the Stack
   for(int i=0; i<500; i++)
      mystack.push( *new Int(i+1) );

   // Pop the values off the Stack, print them, and then destroy them
   for(i=0; i<500; i++)
      {
      Object& thing = mystack.pop();   // assign popped value to a reference
      cout << thing << endl;           // print it
      delete &thing;                   // destroy it
      }

   // Get the finish Date and Time
   Date done_date;
   Time done_time;

   // Print finishing Date and Time
   cout << "Date: " << done_date << "  Time: " << done_time << endl;

   // Compute finish time as hundredths of a second
   long hseconds  = done_time.hour() * 60L * 60L * 100L +
                    done_time.minute()     * 60L * 100L +
                    done_time.second()           * 100L +
                    done_time.hundredths();

   // Subtract off start time, computed as hundredths of a second
        hseconds -= start_time.hour() * 60L * 60L * 100L +
                    start_time.minute()     * 60L * 100L +
                    start_time.second()           * 100L +
                    start_time.hundredths();

   // Correct for midnight roll over by adding in a day, expresed
   //  as hundredths of a second
   if(start_date != done_date)
      hseconds += 24L * 60L * 60L * 100L;

   // Print elapsed time
   cout << "Elapsed Time: " << (hseconds/100.0) << " seconds." << endl;

   return 0;
}
