// Exercise 6

// Create a "Queue" and insert 10 integers on it.  Then take the items off
// the queue until it is empty, printing each number as it is taken off the
// queue.

// Comments

// This is similar to Exercise 2, with a Queue instead of a List and
// slightly different member functions are used.

#include <queue.h>
#include <sortable.h>

class Int : public Sortable {
   int   i;
public:
   Int()      { i = 0; }
   Int(int m) { i = m; }

   classType       isA()       const   { return __firstUserClass; }
   char            *nameOf()   const   { return "Int";            }
   hashValueType   hashValue() const   { return hashValueType(i); }

   void            printOn( ostream& o ) const     { o << i;      }

   int isEqual   (const Object& X) const { return i == ((Int&)X).i; }
   int isLessThan(const Object& X) const { return i <  ((Int&)X).i; }

   operator int()  { return i; }
};

int main()
{
   Queue myqueue;

   // Populate the Queue
   for(int i=0; i<10; i++)
      myqueue.put( *new Int(i+1) );

   // Get an item from the Queue, print it, and then destroy it
   while(myqueue.getItemsInContainer() != 0)
      {
      Object& myobject = myqueue.get();   // get an item
      cout << myobject << endl;           // print it
      delete &myobject;                   // destroy it
      }

   return 0;
}
