// Exercise 5

// Use a "DoubleList" to create the same 10 list of numbers, one in ascending
// order, and the other in descending order.  Use 2 iterators to visit each
// list, printing  out the values along the way.

// Comments

// This is a little vague, since one DoubleList could be used, and then
// instantiate an iterator with initIterator() to print the items in one
// order and then instantiate a second iterator with initReverseIterator()
// to get the other order.

// Since Lists are FILO, iteration is done in reverse on both lists to
// recover the elements in the same order in which they were added to
// the list.  Since operator--() is only defined for a DoubleListIterator,
// an explicit reference to a DoubleListIterator must be instantiated,
// rather than the more common ContainerIterator.

#include <dbllist.h>
#include <sortable.h>

class Int : public Sortable {
   int   i;
public:
   Int()      { i = 0; }
   Int(int m) { i = m; }

   classType       isA()       const   { return __firstUserClass; }
   char            *nameOf()   const   { return "Int";            }
   hashValueType   hashValue() const   { return hashValueType(i); }

   void            printOn( ostream& o ) const     { o << i;      }

   int isEqual   (const Object& X) const { return i == ((Int&)X).i; }
   int isLessThan(const Object& X) const { return i <  ((Int&)X).i; }

   operator int()  { return i; }
};

int main()
{
   DoubleList list1, list2;

   // Populate the two DoubleLists
   for(int i=0; i<10; i++)
      {
      list1.add( *new Int( 1+i) );
      list2.add( *new Int(10-i) );
      }

   // Instantiate an iterator for each DoubleList
   DoubleListIterator& iter_up =
      (DoubleListIterator&) list1.initReverseIterator();
   DoubleListIterator& iter_dw =
      (DoubleListIterator&) list2.initReverseIterator();

   // Print out the items in each DoubleList
   while(iter_up != 0  &&  iter_dw != 0)
      {
      cout << --iter_up << '\t'  << --iter_dw << endl;
      }

   // Clean up the heap
   delete &iter_up;
   delete &iter_dw;

   return 0;
}
