// Exercise 3

// Create a "SortedArray" and put the 10 integers on it.  Then access the
// array with descending subscripts and print the integers as you access the
// descending array elements.

// Comments

// The objects are placed into the array using the add() function and
// simple indexing is used to print each object.

#include <sortarry.h>

class Int : public Sortable {
   int   i;
public:
   Int()      { i = 0; }
   Int(int m) { i = m; }

   classType       isA()       const   { return __firstUserClass; }
   char            *nameOf()   const   { return "Int";            }
   hashValueType   hashValue() const   { return hashValueType(i); }

   void            printOn( ostream& o ) const     { o << i;      }

   int isEqual   (const Object& X) const { return i == ((Int&)X).i; }
   int isLessThan(const Object& X) const { return i <  ((Int&)X).i; }

   operator int()  { return i; }
};

int main()
{
   SortedArray mysarray(9);

   // Populate the SortedArray
   for(int i=0; i<10; i++)
      mysarray.add( *new Int(i+1) );

   // Print the SortedArray elements
   for(i=9; i>=0; i--)
      cout << mysarray[i] << endl;

   return 0;
}
