// Exercise 2

// Create a "List" and push 10 integers on it.  Then take the items off the
// list until the list is empty, printing each number as it is taken off the
// list.

// Comments

// Here, peekHead() is used to look at the next object in the list.
// The object is printed and then destroyed, which brings the next item
// to the head of the list.

#include <list.h>
#include <sortable.h>

class Int : public Sortable {
   int   i;
public:
   Int()      { i = 0; }
   Int(int m) { i = m; }

   classType       isA()       const   { return __firstUserClass; }
   char            *nameOf()   const   { return "Int";            }
   hashValueType   hashValue() const   { return hashValueType(i); }

   void            printOn( ostream& o ) const     { o << i;      }

   int isEqual   (const Object& X) const { return i == ((Int&)X).i; }
   int isLessThan(const Object& X) const { return i <  ((Int&)X).i; }

   operator int()  { return i; }
};

int main()
{
   List mylist;

   // Populate the List
   for(int i=0; i<10; i++)
      mylist.add( *new Int(i+1) );

   // Look at the next item in the List, print it, and then destroy it
   while(mylist.getItemsInContainer() != 0)
      {
      Object& myobject = mylist.peekHead();     // look at next object
      cout << myobject << endl;                 // print it
      mylist.detach(myobject);                  // detach it
      delete &myobject;                         // destroy it
      }

   return 0;
}
