// Exercise 4

// Using the same list as in 2, instantiate a "ListIterator" and visit all
// the items on the list, printing out each item as you visit it.

// Comments

// Exercise 2 used a while() loop to go through the list until
// getItemsInContainer() reported no more items in the list.
// Here, an iterator is used.

#include <list.h>
#include <sortable.h>

class Int : public Sortable {
   int   i;
public:
   Int()      { i = 0; }
   Int(int m) { i = m; }

   classType       isA()       const   { return __firstUserClass; }
   char            *nameOf()   const   { return "Int";            }
   hashValueType   hashValue() const   { return hashValueType(i); }

   void            printOn( ostream& o ) const     { o << i;      }

   int isEqual   (const Object& X) const { return i == ((Int&)X).i; }
   int isLessThan(const Object& X) const { return i <  ((Int&)X).i; }

   operator int()  { return i; }
};

int main()
{
   List mylist;

   // Populate the List
   for(int i=0; i<10; i++)
      mylist.add( *new Int(i+1) );

   ContainerIterator& myiterator = mylist.initIterator();

   // Iterate through the List, printing each object
   while(myiterator)
      {
      cout << ++myiterator << endl;
      }

   // initIterator() allocates from the heap, so clean things up
   delete &myiterator;

   return 0;
}
