// Exercise 10

// Create an "Array" of three "Dictionary" objects, the first from German to
// English, the second from English to German, and the third from English to
// French.  Populate each dictionary with five words.  Then print out each
// dictionary (in the reverse order from what is stated above) and in reverse
// alphabetical sequence within each dictionary.

// Comments

// Actual French and German words are "simulated" for simplicity.

// The Associations within a Dictionary are not intrisically Sortable
// so a function is used to extract the key values of each Association
// into a SortedArray, and then the SortedArray is indexed in reverse
// order and the corresponding Association is printed.

#include <dict.h>
#include <strng.h>
#include <array.h>
#include <sortarry.h>

void print_dict_rev(Dictionary& mydict);

int main()
{
   // Create Dictionaries
   Dictionary& GE = *new Dictionary;
   Dictionary& EG = *new Dictionary;
   Dictionary& EF = *new Dictionary;

   // Populate the German-English Dictionary
   GE.add( *new Association( *new String("German word 4"),
                             *new String("English word 4") ) );
   GE.add( *new Association( *new String("German word 5"),
                             *new String("English word 5") ) );
   GE.add( *new Association( *new String("German word 1"),
                             *new String("English word 1") ) );
   GE.add( *new Association( *new String("German word 3"),
                             *new String("English word 3") ) );
   GE.add( *new Association( *new String("German word 2"),
                             *new String("English word 2") ) );

   // Populate the English-German Dictionary
   EG.add( *new Association( *new String("English word 4"),
                             *new String("German word 4") ) );
   EG.add( *new Association( *new String("English word 5"),
                             *new String("German word 5") ) );
   EG.add( *new Association( *new String("English word 1"),
                             *new String("German word 1") ) );
   EG.add( *new Association( *new String("English word 3"),
                             *new String("German word 3") ) );
   EG.add( *new Association( *new String("English word 2"),
                             *new String("German word 2") ) );

   // Populate the English-French Dictionary
   EF.add( *new Association( *new String("English word 4"),
                             *new String("French word 4") ) );
   EF.add( *new Association( *new String("English word 5"),
                             *new String("French word 5") ) );
   EF.add( *new Association( *new String("English word 1"),
                             *new String("French word 1") ) );
   EF.add( *new Association( *new String("English word 3"),
                             *new String("French word 3") ) );
   EF.add( *new Association( *new String("English word 2"),
                             *new String("French word 2") ) );

   // Create the array
   Array myarray(2);

   // Put Dictionaries into the Array as required
   myarray.add(GE);
   myarray.add(EG);
   myarray.add(EF);

   // Go through the Array backwards, printing each Dictionary (backwards)
   for(int i=2; i>=0; i--)
      print_dict_rev( (Dictionary&) myarray[i] );

   return 0;
}

// Function to print the contents of a Dictionary in sorted reverse order
void print_dict_rev(Dictionary& mydict)
{
   // Create a SortedArray to hold the key values
   SortedArray myarray( 4, 0, 1 );

   // Instantiate an iterator to step through the Dictionary
   ContainerIterator& nxt = mydict.initIterator();

   int items = 0;    // count items in dictionary

   // Retrieve each Association, add the key to the SortedArray
   while(nxt)
      {
      Association& thing = (Association&)nxt++;
      myarray.add( *new String( (String&)thing.key() ) );
      ++items;
      }

   delete &nxt;   // clean up heap

   // Print Associations in reverse order
   for(int i=items-1; i>=0; i--)
      cout << mydict.lookup( myarray[i] );

   cout << endl;
}
