// Exercise 1

// Create a "Stack" and push 10 integers on it.  Then pop them all off and
// print them.

// Comments

// The class library doesn't deal directly with integers; a class needs
// to be derived (directly or indirectly) from class Object.  Here, a simple
// Int class is used, derived from class Sortable.

#include <stack.h>
#include <sortable.h>

class Int : public Sortable {
   int   i;
public:
   Int()      { i = 0; }
   Int(int m) { i = m; }

   classType       isA()       const   { return __firstUserClass; }
   char            *nameOf()   const   { return "Int";            }
   hashValueType   hashValue() const   { return hashValueType(i); }

   void            printOn( ostream& o ) const     { o << i;      }

   int isEqual   (const Object& X) const { return i == ((Int&)X).i; }
   int isLessThan(const Object& X) const { return i <  ((Int&)X).i; }

   operator int()  { return i; }
};

int main()
{
   Stack mystack;

   // Push some values onto the Stack
   for(int i=0; i<10; i++)
      mystack.push( *new Int(i+1) );

   // Pop the values off the Stack, print them, and then destroy them
   for(i=0; i<10; i++)
      {
      Object& thing = mystack.pop();   // assign popped value to a reference
      cout << thing << endl;           // print it
      delete &thing;                   // destroy it
      }

   return 0;
}
