/*

Main application module for test of color selector custom control

(C) Scott Gourley, 1991.

*/

#include <windows.h>

#include "clrctrl.h"
#include "clrtest.h"

long FAR PASCAL WndProc (HWND, WORD, WORD, LONG);

COLORREF	clrText = CLRTEST_TEXT_COLOR;
COLORREF	clrBack = CLRTEST_BACKGROUND_COLOR;

int PASCAL WinMain
	(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
	WNDCLASS	wndclass;
	HANDLE		hClrLib;
	HANDLE		hAccel;
	HWND		hWnd;
	MSG			msg;
	static char	szAppName [] = "ClrTest";

	/* load custom control DLL library, end program on error */
	
	if ((hClrLib = LoadLibrary (CLRCTRL_DLLNAME)) < 32)
		return 0;

	/* register the window class if this is the only program instance */
	
	if (!hPrevInstance)
	{
		/* register the frame window class */

		wndclass.style			= CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc	= WndProc;
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= 0;
		wndclass.hInstance		= hInstance;
		wndclass.hIcon			= LoadIcon (hInstance, szAppName);
		wndclass.hCursor		= LoadCursor (NULL, IDC_ARROW);
		wndclass.hbrBackground	= NULL;
		wndclass.lpszMenuName	= szAppName;
		wndclass.lpszClassName	= szAppName;
	
		RegisterClass (&wndclass);		
	}

	/* create the application window */

	hWnd = CreateWindow (szAppName, "Color Selector Test", 
								WS_OVERLAPPEDWINDOW,
								CW_USEDEFAULT, CW_USEDEFAULT,
								240, 100,
								NULL, NULL, hInstance, NULL);

	/* load the keyboard accelerators */
							
	hAccel = LoadAccelerators (hInstance, "Accelerators");
	
	/* make the frame window visible */
	
	ShowWindow (hWnd, nCmdShow);
	UpdateWindow (hWnd);
	
	/* enter the message loop */
	
	while (GetMessage (&msg, NULL, 0, 0))
	{
		/* if there is no accel key to translate, process the message */
		
		if (!hAccel || !TranslateAccelerator (hWnd, hAccel, &msg))
		{
			TranslateMessage (&msg);
			DispatchMessage (&msg);
		}
	}
	
	FreeLibrary (hClrLib);

	return msg.wParam;
}

BOOL FAR PASCAL ClrTestDlgProc
	(HWND hDlg, WORD wMsg, WORD wParam, LONG lParam)
{
	HWND			hClrCtrl;

	switch (wMsg)
	{
		case WM_INITDIALOG:

			/* get a handle to the text color selector */
			
			hClrCtrl = GetDlgItem (hDlg, ID_CLRSEL_TEXT);

			/* delete the dark magenta item, just for fun */

			SendMessage (hClrCtrl, CB_DELETESTRING, 5, 0L);
			
			/* put a sky-blue item at position 3, just for fun */

			SendMessage (hClrCtrl, CB_INSERTSTRING, 3,
				RGB (0x00, 0x80, 0xFF));
			
			/* set the default text color (to clrText's initial value) */

			SendMessage (hClrCtrl, CLRM_SETCURCOLOR, 0, clrText);

			/* get a handle to the background color selector */

			hClrCtrl = GetDlgItem (hDlg, ID_CLRSEL_BACKGROUND);

			/* add an orangish item to the end of the list, just for fun */
			
			SendMessage (hClrCtrl, CB_ADDSTRING, 0,
				RGB (0xC0, 0x40, 0x00));
			
			/* set the default background color (to clrBack's init value) */

			SendMessage (hClrCtrl, CLRM_SETCURCOLOR, 0, clrBack);

			return TRUE;

			break;
			
		case WM_COMMAND:
			switch (wParam)
			{
				case IDOK:

					/* access the text color selector... */

					hClrCtrl = GetDlgItem (hDlg, ID_CLRSEL_TEXT);
					
					/* ...and retrieve the current color setting */

					clrText = SendMessage (hClrCtrl, CLRM_GETCURCOLOR, 0, 0L);

					/* access the background color selector... */
					
					hClrCtrl = GetDlgItem (hDlg, ID_CLRSEL_BACKGROUND);
					
					/* ...and retrieve the current color setting */

					clrBack = SendMessage (hClrCtrl, CLRM_GETCURCOLOR, 0, 0L);

					/* fall through to end the dialog */

				case IDCANCEL:

					/* end the dialog */
					
					EndDialog (hDlg, 0);

					return TRUE;

				case ID_CLRSEL_RESET:

					/* reset the current colors to the default values */

					clrText = CLRTEST_TEXT_COLOR;
					clrBack = CLRTEST_BACKGROUND_COLOR;

					/* reset the current text color selection */
					
					SendMessage (GetDlgItem (hDlg, ID_CLRSEL_TEXT),
						CLRM_SETCURCOLOR, 0, clrText);
					
					/* reset the current background color selection */

					SendMessage (GetDlgItem (hDlg, ID_CLRSEL_BACKGROUND),
						CLRM_SETCURCOLOR, 0, clrBack);

					break;
			}
			break;
	}
	
	return FALSE;
}

BOOL FAR PASCAL AboutDlgProc
	(HWND hDlg, WORD wMsg, WORD wParam, LONG lParam)
{
    switch (wMsg)
    {
        case WM_COMMAND:

			switch (wParam)
            {
				case IDCANCEL:
                case IDOK:

					EndDialog (hDlg, 0);

                    return TRUE;
					
					break;
            }

			break;
    }
            
    return (FALSE);
}

LONG FAR PASCAL WndProc
	(HWND hWnd, WORD wMsg, WORD wParam, LONG lParam)
{
	static FARPROC	lpfnClrTestDlgProc;
	static FARPROC	lpfnAboutDlgProc;
	static HANDLE	hInstance;
	
	switch (wMsg)
	{
		/* create the application window */
		
		case WM_CREATE:
			/* save the program's instance handle */
			
			hInstance = ((LPCREATESTRUCT) lParam)->hInstance;
			
            /* create instance "thunks" for the dialog box procedures */
        
			lpfnClrTestDlgProc =
				MakeProcInstance (ClrTestDlgProc, hInstance);
			lpfnAboutDlgProc =
				MakeProcInstance (AboutDlgProc, hInstance);

			return 0;
			
		case WM_COMMAND:
			switch (wParam)
			{
				case IDM_EXIT:

					/* end the application */

					SendMessage (hWnd, WM_CLOSE, 0, 0L);

					return 0;

					break;
					
				case IDM_CLRTEST:

					/* put up the dial test dialog box */

					DialogBox (hInstance, "ClrTest",
						hWnd, lpfnClrTestDlgProc);

					/* repaint the window, to get the new selected colors */
					
					InvalidateRect (hWnd, NULL, TRUE);

					return 0;
					
					break;

				case IDM_INDEXHELP:
					
					WinHelp (hWnd, CLRCTRL_HLPNAME, HELP_INDEX, 0L);

					break;
				
				case IDM_COMMANDHELP:

					WinHelp (hWnd, CLRCTRL_HLPNAME, HELP_CONTEXT, 1L);
					
					break;

					WinHelp (hWnd, CLRCTRL_HLPNAME, HELP_INDEX, 0L);

					break;
				
				case IDM_USINGHELP:

					WinHelp (hWnd, CLRCTRL_HLPNAME, HELP_HELPONHELP, 0L);

					break;
				
				case IDM_ABOUT:

					/* put up the dial test about dialog box */

					DialogBox (hInstance, "About",
						hWnd, lpfnAboutDlgProc);

					/* repaint the window, to get the new selected colors */
					
					InvalidateRect (hWnd, NULL, TRUE);

					return 0;
					
					break;
			}

			break;

		case WM_PAINT:
		{
			PAINTSTRUCT	ps;
			HBRUSH		hBrush;
			HPEN		hPen;
			RECT		rect;
			HDC			hDC;

			/* start painting, and get a device context */
			
			hDC = BeginPaint (hWnd, &ps);

			/* determine the size of the application window to paint on */
			
			GetClientRect (hWnd, &rect);

			/* set the appropriate text and text background colors */
			
			SetTextColor (hDC, clrText);
			SetBkColor (hDC, clrBack);
			SetBkMode (hDC, TRANSPARENT);
			
			/* create solid colored brush and pen to paint the background */
			
			hBrush = CreateSolidBrush (clrBack);
			hPen = CreatePen (PS_INSIDEFRAME, 2, clrBack);

			/* select the brush and pen into the DC, saving the old values */

			hBrush = SelectObject (hDC, hBrush);
			hPen = SelectObject (hDC, hPen);
			
			/* paint the window with the background color */
			
			Rectangle (hDC, rect.left, rect.top, rect.right, rect.bottom);

			/* paint the text, centered in the window, in the correct color */
			
			DrawText (hDC, (LPSTR) "Change colors using Options!", -1, &rect,
				DT_SINGLELINE | DT_CENTER | DT_VCENTER);

			/* restore the old brush and pen */
			
			hBrush = SelectObject (hDC, hBrush);
			hPen = SelectObject (hDC, hPen);
			
			/* delete the created brush */
			
			DeleteObject (hBrush);
			DeleteObject (hPen);
			
			/* end the painting */
			
			EndPaint (hWnd, &ps);

			return 0;

			break;
		}

		case WM_DESTROY :
			
			/* close the help utility */
			
			WinHelp (hWnd, CLRCTRL_HLPNAME, HELP_QUIT, 0L);

			/* end the program */

			PostQuitMessage (0);

			return 0;
	}
	
	/* hand all unprocessed messages to the default window-proc in Windows */
	
	return DefWindowProc (hWnd, wMsg, wParam, lParam);
}

