//*
// CMSLIN.CPP - Declaration of a set of classes to parse the command
// line in a cean, easy to use fashion.
//
// 920321 MMCMason - Originally written
//*

#define clsANY_ARG		31	// This token will matches all arguments
#define clsARG(x)		(x)	// This token matches argement number x
#define clsTOOMANYARGS	1	// Error bit for 'Too many arguments'
#define clsBADSWITCH	2	// Err bit for 'bad command line switch'

//--------------------------------------------------------------------------
// baseCLSwitch - The basic features of a command line switch.  The
// comman dline switch consists of a switch character (swchar), an
// action to perform when the switch is found on the command line
// (action, usually NULL), and a value.  Since the value varies,
// depenedning on the type, we use inheritance to tie a value to the rest
// of the command line switch.
//
class baseCLSwitch
	{
	public:
		baseCLSwitch( char sw, int (*act)( char * ) NULL )
			: swchar(sw), action(act)
			{
			next = head;
			head = this;
			}
		virtual int Value( char *text )=0;
		static int parse( int argc, char **argv );
		static baseCLSwitch *head;  // First CLSwitch in chain
	protected:
		int doAction( char *text )
			{
			if ( action ) return (*action)( text );
			else		  return 0;
			}

	private:
		char swchar;				// Character mapping to switch
		int (*action)( char * );	// action to perform when found

		baseCLSwitch *next;			// next CLSwitch in the chain
	};

//--------------------------------------------------------------------------
// CLSwitch - a template class the adds the management of the value
// of the commandl ine switch (baseCLSWitch) class.
//
template< class T > class CLSwitch : public baseCLSwitch
	{
	public:
		CLSwitch( char sw, T dflt, int (*act)( char * )=NULL )
			: baseCLSwitch( sw, act ), value(dflt) { }
		int Value( char *text );
		const T& Value( ) { return value; }
	private:
		T value;
	};

template< class T > int CLSwitch<T>::Value( char *text )
	{
	value = text;
	return doAction( text );
	}

inline int CLSwitch<int>::Value( char *text )
	{
	value = atoi( text );
	return doAction( text );
	}

inline int CLSwitch<double>::Value( char *text)
	{
	value = atof( text );
	return doAction( text );
	}

inline int CLSwitch<char>::Value( char *text )
	{
	value = *text;
	return doAction( text );
	}

inline int CLSwitch<char*>::Value( char *text )
	{
	value = text;
	return doAction( text );
	}
