//**************************************************************************
//  CMDLIN.CPP - Definition of the functions, static data, and class
// methods for the command line parsing class.
//
// 920321 MCMason - originally written.
//*

#include <stdlib.h>
#include "cmdlin.hpp"

//_______________________________
//   baseCLSwitch data and methods
//------------------------------------
//we start out with no command line switches whatsoever
baseCLSwitch::parse( int argc, char **argv )
	{
	int ErrorList = 0, ArgCount = 0;

	for ( int i=0; i<argc; i++ )
		if ( ('-'==argv[i][0]) || ('/'==argv[i][0]) )
			{
			// Process command line switches
			baseCLSwitch *tmp = baseCLSwitch::head;
			while ( (NULL!=tmp) && (argv[i][1] != tmp->swchar) )
				tmp = tmp->next;
			if ( NULL==tmp )
				ErrorList |= clsBADSWITCH;
			else
				ErrorList |= tmp->Value( argv[i]+2 );
			}
		else
			{
			//Process command line arguments
			baseCLSwitch *tmp = baseCLSwitch::head;
			while ( (NULL!=tmp) && (clsARG(ArgCount)!=tmp->swchar)
					&& !((clsANY_ARG==tmp->swchar) && ArgCount) )
				tmp = tmp->next;
			if ( NULL==tmp )
				{
				// Don't return an error if the user doesn't
				// want to process argument 0
				if ( ArgCount ) ErrorList |= clsTOOMANYARGS;
				}
			else
				ErrorList |= tmp->Value( argv[i] );
			++ArgCount;
			}
	return ErrorList;
	}
