// *************************************************************** //
// Filename:    SDIBar.h                                           //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //

#ifndef SDIBar_H
#define SDIBar_H

#include <owl\owlcore.h>
#include <owl\statusba.h>
#include <owl\controlb.h>
#include <owl\buttonga.h>
#include <windowsx.h>
#pragma hdrstop
#include "SDIBar.rh"

// --------------------------------------------------------------- //
// TRemoveChildDecoratedFrame                                      //
// --------------------------------------------------------------- //
class TRemoveChildDecoratedFrame : public TDecoratedFrame
{
  public:
    TRemoveChildDecoratedFrame(TWindow *parent,
      const char far* title, TWindow *clientWnd,
      BOOL trackMenuSelection = FALSE, TModule *module = 0);
    void RemoveDecorationWindow(TWindow *);
};

// --------------------------------------------------------------- //
// TSmartStatusBar                                                 //
// --------------------------------------------------------------- //
class THintStatusBar : public TStatusBar
{
  public:
    THintStatusBar(TWindow *parent = 0,
      TGadget::TBorderStyle borderStyle = TGadget::Recessed,
      UINT modeIndicators = 0, TFont *font = new TGadgetWindowFont,
      TModule *module = 0);
    virtual void SetHintText(const char* text);
};

// --------------------------------------------------------------- //
// SDIBarApplication                                              //
// --------------------------------------------------------------- //
class TSDIBarApp : public TApplication 
{
  public:
    THintStatusBar *StatusBar;
    TControlBar *ControlBar;

    TSDIBarApp();
   ~TSDIBarApp();
    void InitMainWindow();
};

// --------------------------------------------------------------- //
// SDIBarWindow                                                   //
// --------------------------------------------------------------- //
class TSDIBarWindow : public TWindow 
{
  public:
    TSDIBarWindow();
   ~TSDIBarWindow();

    void GetWindowClass(WNDCLASS& wndClass);
    char *GetClassName();
    void SetupWindow();
    void CleanupWindow();
  
    DECLARE_RESPONSE_TABLE(TSDIBarWindow);
  protected:
    void EvPaint();
    void EvSize(UINT sizeType, TSize& size);
    void IdHappy();

    void EvEnableCbHide(TCommandEnabler &);
    void EvEnableCbShow(TCommandEnabler &);
    void CbHide();
    void CbShow();
    BOOL IsControlBarHidden;
};

#endif


