// *************************************************************** //
// Filename:    app.cpp                                            //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //

#include "SDIBar.h"

// --------------------------------------------------------------- //
// Application constructor                                         //
// --------------------------------------------------------------- //
TSDIBarApp::TSDIBarApp() : 
  TApplication() 
{
}

// --------------------------------------------------------------- //
// Application destructor                                          //
// --------------------------------------------------------------- //
TSDIBarApp::~TSDIBarApp()
{
}

// --------------------------------------------------------------- //
// InitMainWindow                                                  //
// --------------------------------------------------------------- //
void TSDIBarApp::InitMainWindow()
{
  TRemoveChildDecoratedFrame *Frame = 
    new TRemoveChildDecoratedFrame(NULL, "SDIBar application", 
    new TSDIBarWindow, TRUE);
  Frame->AssignMenu("MainMenu");
  // create the toolbar
  ControlBar = new TControlBar(Frame, TControlBar::Horizontal);
  ControlBar->Insert(*new TButtonGadget("happy", ID_HAPPY));
  ControlBar->SetHintMode(TGadgetWindow::EnterHints);
  Frame->Insert(*ControlBar, TDecoratedFrame::Top);
  // create the status bar
  StatusBar = new THintStatusBar(Frame, TGadget::Embossed, 0,
    new TFont("Times New Roman", 18));
  Frame->Insert(*StatusBar, TDecoratedFrame::Bottom);
  SetMainWindow(Frame);
}

// --------------------------------------------------------------- //
// OwlMain                                                         //
// --------------------------------------------------------------- //
int OwlMain(int /*argc*/, char* /*argv*/ [])
{
  TSDIBarApp app;
  return app.Run();
}

TRemoveChildDecoratedFrame::TRemoveChildDecoratedFrame(TWindow *parent,
  const char far* title, TWindow *clientWnd, BOOL trackMenuSelection, 
  TModule *module) :
  TDecoratedFrame(parent, title, clientWnd, trackMenuSelection, module)
{
}

void TRemoveChildDecoratedFrame::RemoveDecorationWindow(TWindow *window)
{
  RemoveChild(window);
  RemoveChildLayoutMetrics(*window);
  Layout();
}

