// *************************************************************** //
// Filename:    SDIBar.cpp                                         //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //
#include "SDIBar.h"

// --------------------------------------------------------------- //
// SDIBarWindow constructor                                       //
// --------------------------------------------------------------- //
TSDIBarWindow::TSDIBarWindow() :
  TWindow(0, 0, 0)
{
  IsControlBarHidden = FALSE;
}

// --------------------------------------------------------------- //
// SDIBarWindow destructor                                        //
// --------------------------------------------------------------- //
TSDIBarWindow::~TSDIBarWindow()
{
}

// --------------------------------------------------------------- //
// GetClassName                                                    //
// --------------------------------------------------------------- //
char *TSDIBarWindow::GetClassName()
{
  return "SDIBarClass";
}

// --------------------------------------------------------------- //
// GetWindowClass                                                  //
// --------------------------------------------------------------- //
void TSDIBarWindow::GetWindowClass(WNDCLASS &wc)
{
  TWindow::GetWindowClass(wc);
  wc.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
}

// --------------------------------------------------------------- //
// SetupWindow                                                     //
// --------------------------------------------------------------- //
void TSDIBarWindow::SetupWindow()
{
  TWindow::SetupWindow();
  // put new stuff here
  TSDIBarApp *app = TYPESAFE_DOWNCAST(GetApplication(), TSDIBarApp);
  app->StatusBar->SetText("In SetupWindow");
}

// --------------------------------------------------------------- //
// CleanupWindow                                                   //
// --------------------------------------------------------------- //
void TSDIBarWindow::CleanupWindow()
{
  // put new stuff here
  TWindow::CleanupWindow();
}

// --------------------------------------------------------------- //
// Response table for SDIBarWindow                                //
// --------------------------------------------------------------- //
DEFINE_RESPONSE_TABLE1(TSDIBarWindow, TWindow)
  EV_WM_PAINT,
  EV_WM_SIZE,
  EV_COMMAND(ID_HAPPY, IdHappy),
  EV_COMMAND_ENABLE(CB_HIDE,  EvEnableCbHide),
  EV_COMMAND       (CB_HIDE,  CbHide),
  EV_COMMAND_ENABLE(CB_SHOW,  EvEnableCbShow),
  EV_COMMAND       (CB_SHOW,  CbShow),
END_RESPONSE_TABLE;


// --------------------------------------------------------------- //
// Draw3DRect                                                      //
// --------------------------------------------------------------- //
void Draw3DRect(TDC &dc, TRect &rect, TPen Hilite, TPen Shadow)
{
  dc.SelectObject(Hilite);
  dc.MoveTo(rect.left, rect.bottom);
  dc.LineTo(rect.left, rect.top);
  dc.LineTo(rect.right, rect.top);
  dc.MoveTo(rect.right-1, rect.top);
  dc.LineTo(rect.right-1, rect.bottom-1);
  dc.LineTo(rect.left+1, rect.bottom-1);
  dc.RestorePen();

  dc.SelectObject(Shadow);
  dc.MoveTo(rect.left+1, rect.bottom-1);
  dc.LineTo(rect.left+1, rect.top+1);
  dc.LineTo(rect.right-1, rect.top+1);
  dc.MoveTo(rect.right, rect.top);
  dc.LineTo(rect.right, rect.bottom);
  dc.LineTo(rect.left, rect.bottom);
  dc.RestorePen();
}

// --------------------------------------------------------------- //
// WM_PAINT                                                        //
// --------------------------------------------------------------- //
void TSDIBarWindow::EvPaint()
{
  TPaintDC dc(HWindow);
  TRect rect;

  GetClientRect(rect);
  rect.right--;
  rect.bottom--;
  Draw3DRect(dc, rect, GetStockPen(WHITE_PEN), GetStockPen(BLACK_PEN));
}

// --------------------------------------------------------------- //
// WM_SIZE                                                         //
// --------------------------------------------------------------- //
void TSDIBarWindow::EvSize(UINT, TSize &)
{
  Invalidate(TRUE);
}


// --------------------------------------------------------------- //
// IDHappy                                                         //
// --------------------------------------------------------------- //
void TSDIBarWindow::IdHappy()
{
  MessageBox("Have a happy day!", "Joy", MB_OK);
}

void TSDIBarWindow::EvEnableCbHide(TCommandEnabler &cmdEnabler)
{
  cmdEnabler.Enable(!IsControlBarHidden);
}

void TSDIBarWindow::EvEnableCbShow(TCommandEnabler &cmdEnabler)
{
  cmdEnabler.Enable(IsControlBarHidden);
}

void TSDIBarWindow::CbHide()
{
  IsControlBarHidden = !IsControlBarHidden;
  TSDIBarApp *app = TYPESAFE_DOWNCAST(GetApplication(), TSDIBarApp);
  TRemoveChildDecoratedFrame *frame = 
    TYPESAFE_DOWNCAST(app->GetMainWindow(), TRemoveChildDecoratedFrame);
  app->ControlBar->Show(SW_HIDE);
  frame->RemoveDecorationWindow(app->ControlBar);
}

void TSDIBarWindow::CbShow()
{
  IsControlBarHidden = !IsControlBarHidden;
  TSDIBarApp *app = TYPESAFE_DOWNCAST(GetApplication(), TSDIBarApp);
  TRemoveChildDecoratedFrame *frame = 
    TYPESAFE_DOWNCAST(app->GetMainWindow(), TRemoveChildDecoratedFrame);
  app->ControlBar->Show(SW_RESTORE);
  frame->Insert(*app->ControlBar, TDecoratedFrame::Top);
  frame->Layout();
}


THintStatusBar::THintStatusBar(TWindow *parent, 
  TGadget::TBorderStyle borderStyle, UINT modeIndicators, 
  TFont *font, TModule *module) :
  TStatusBar(parent, borderStyle, modeIndicators, font, module)
{
}

void THintStatusBar::SetHintText(const char* text)
{
  SetText(text);
}

