/*
	flcpp2cl.h -- Container Lite v 1.87:
		FlexList II C++ wrapper.

	(C) Copyright 1994  John Webster Small
	All rights reserved
*/

#ifdef  FLEXLIST_CPP
#error  Include "flcpp2cl.h" instead of "flexlist.hpp"
#endif

#ifndef flcpp2cl_h
#define flcpp2cl_h

#define CL_NO_TEMPLATES
#include "cl.h"

#define FLvariantData  0
#define FLstrings  FLvariantData
#define FLmaxMaxNodes  CL_MAXNODES

class	FlexList;
typedef	FlexList *FlexL;
#define FlexL0  ((FlexL)0)
typedef struct { char data[1]; } FlexNode;
typedef	FlexNode *FlexN;
#define FlexN0  ((FlexN)0)

#define FLcomparE(compare)  ((voidCmP) compare)
#define FLcompare0  FLcomparE(0)

class FlexList : cl  {
	unsigned sizeofNodeData;
static  char nullD[];
protected:
	virtual FlexN FNnew(const void * D);
	virtual int   FNwrite(void *ND, const void *D);
	virtual int   FNread(const void *ND, void *D);
	virtual int   FNdestruct(void *ND, void *D)
		{ return 1; }

	virtual void * assignD(void * D, const void * S);
	virtual void * newD(const void * D);
	virtual void   deleteD(void * D);

public:
	FlexList(unsigned sizeofNodeData, unsigned maxNodes
		= FLmaxMaxNodes)
		: cl(CL_ASG|CL_NEW|CL_DEL,maxNodes)
		{ this->sizeofNodeData = sizeofNodeData; }
	//  Unpack array into FlexList
	FlexList(unsigned sizeofCell, unsigned cells,
		const void *array);

	// FlexList destructors:
	int   clear()  { return allDel();  }
	virtual ~FlexList() { destruct(); }

	// FlexList header functions:
	void *frontD() { return top(); }
	void *currentD()  { return get(); }
	void *rearD() { return rear(); }
	unsigned CurNum()
	{ return ((CurNode() < Nodes())? CurNode()+1 : 0); }
	cl::Nodes;
	cl::MaxNodes;
	cl::setMaxNodes;
	unsigned notFull() { return vacancy(); }
	unsigned SizeofNodeData() { return sizeofNodeData; }
	int   isSorted() { return (int) Sorted(); }
	int   unSort()  { cl::unSort(); return 1; }
	voidCmP Compare() { return CmP(); }
	void  setCompare(voidCmP compare)
		{ setCmP(compare); }
	unsigned isFixed() { return sizeofNodeData; }
	unsigned isVariant() { return !sizeofNodeData; }

	// FlexList stack and queue functions:
	void *pushN(FlexN N)  { return push(N); }
	void *pushD(const void *D = 0)
		{ return pushNew((void *)(D?D:nullD)); }
	FlexN popN()  { return (FlexN) pop(); }
	int   popD(void *D = 0)
		{ return (D? (int) popDelAsg(D) : popDel()); }
	void *topD(void *D = 0)
		{ return (D? topAsg(D) : top()); }
	void *insQN(FlexN N)
		{ return insQ(N); }
	void *insQD(const void *D = 0)
		{ return insQNew((void *)(D?D:nullD)); }

	// FlexList list functions:
	void *mkcur(unsigned n = 0)
		{ (void) setCurNode(n?n-1:CL_MAXNODES);
		return get(); }
	void *insN(FlexN N)  { return ins(N); }
	void *insD(const void *D = 0)
		{ return insNew((void *)(D?D:nullD)); }
	void *insSortN(FlexN N)  { return insSort(N); }
	void *insSortD(const void *D)
		{ return insSortNew((void *)(D?D:nullD)); }
	FlexN delN()  { return (FlexN) rmv();  }
	int   delD(void *D = 0)
		{ return (D? (int) delAsg(D) : del()); }
	void *nextD(void *D = 0)
		{ return (D? nextAsg(D) : next()); }
	void *prevD(void *D = 0)
		{ return (D? prevAsg(D) : prev()); }

	// FlexList search/sort functions:
	// (see also insSortN()/insSortD() list functions)
	void *findFirstD(const void *D)
		{ return findFirst(D); }
	void *findNextD(const void *D)
		{ return findNext(D); }
	void *findLastD(const void *D)
		{ return findLast(D); }
	void *findPrevD(const void *D)
		{ return findPrev(D); }
	cl::sort;

	// FlexList array functions:
	// See also compaction functions
	int   storeD(const void *D, unsigned n = 0);
	int   recallD(void *D, unsigned n = 0);

	// FlexList compaction functions:
	// (see also FlexList constructors)
	void *pack();
	void **packPtrs()  { return vector(); }
};

#define FLnewAlignLoss  16
#define FLmaxSizeofNodeData  \
	((size_t)(-(long)sizeof(FlexNode) \
	-FLnewAlignLoss))
#define FLmaxSizeofArray ((long)(size_t)-FLnewAlignLoss)

#endif
