/*
	flcpp2cl.cpp -- Container Lite  v 1.87:
		FlexList II C++ wrapper.

	(C) Copyright 1994  John Webster Small
	All rights reserved
*/

#include "flcpp2cl.h"

char FlexList::nullD[1];

FlexN FlexList::FNnew(const void *D)
{
	FlexN N;
	size_t i;

	for (i = 0; ((char *)D)[i++];);
	if ((N = (FlexN) new char[i]) != FlexN0)
		memcpy(N,D,i);
	return N;
}

int FlexList::FNwrite(void *ND, const void *D)
{
	char *nd, *d;
	
	nd = (char *) ND;
	d = (char *) D;
	while (*nd)
		if ((*nd++ = *d++) == '\0')
			break;
	return 1;
}

int FlexList::FNread(const void *ND, void *D)
{
	char *nd, *d;
	
	nd = (char *) ND;
	d = (char *) D;
	while ((*d++ = *nd++) != '\0')
		/* null statement */;
	return 1;
}

void *  FlexList::assignD(void * D, const void * S)
{
	if (sizeofNodeData)
		return memcpy(D,S,sizeofNodeData);
	else if (Flags(CL_READ|CL_READ_DEL))  {
		if (FNread(S,D))
			return D;
	}
	else if (FNwrite(D,S))
		return D;
	return 0;
}

void *  FlexList::newD(const void * D)
{
	if (sizeofNodeData)  {
		void * N = (void *)
			new char[sizeofNodeData];
		if (N) if (D == nullD)
			memset(N,0,sizeofNodeData);
		else
			memcpy(N,D,sizeofNodeData);
		return N;
	}
	else if (D != nullD)
		return (void *) FNnew(D);
	return (void *)0;
}

void  FlexList::deleteD(void * D)
{
	FNdestruct(D,0);
	delete D;
}

FlexList::FlexList(unsigned sizeofCell, unsigned cells,
	const void * array)
	: cl(CL_ASG|CL_NEW|CL_DEL,
	CL_MAXNODES,cells)
{
  if ((sizeofNodeData = sizeofCell) != 0)
    if (cells && array)
      for (unsigned i = 0; i < cells; i++)
        if (!insQNew(&(((char *)array)[i*sizeofCell])))
          break;
}

int FlexList::storeD(const void *D, unsigned n)
{
	if (n) setCurNode(n-1);
	return (int) putAsg(D);
}

int FlexList::recallD(void *D, unsigned n)
{
	if (n) setCurNode(n-1);
	return (int) getAsg(D);
}


void * FlexList::pack()  // Only fixed nodes!
{
	long sizeofArray;
	char *A, *Ai;
	unsigned i;

	sizeofArray = ((long)sizeofNodeData)
		* ((long)Nodes());
	if ((sizeofArray <= 0) || 
		(sizeofArray > FLmaxSizeofArray))
		return (void *) 0;
	if ((A = new char [(unsigned) sizeofArray]) 
		== (char *) 0)
		return (void *) 0;
	for (Ai = A, i = 0; i < Nodes() ; i++,
		Ai += sizeofNodeData)
		memcpy(Ai,atGet(i),sizeofNodeData);
	return A;
}
