/*
	picklist.hpp
	7-30-91
	Demo of coding with FlexList II

	Copyright 1991
	John W. Small
	All rights reserved

	Licensed users of FlexList are free to use and
	modify this tool for use in their programs.

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, VA 22102 8072 USA

	Voice: (703) 759-3838
	CIS: 73757,2233

*/

#ifndef PICKLIST_HPP
#define PICKLIST_HPP

#include <string.h>
#include <conio.h>

//#ifndef FLEXLIST_CPP
//#include <flexlist.hpp>
//#endif
#ifndef flcpp2cl_h
#include "flcpp2cl.h"
#endif

#ifndef PCWIN_HPP
#include "pcwin.hpp"
#endif


#define MAX_PL_PREFIX  21


class PickList : public FlexList {
	int status;
protected:
	PalettE P;
	char prefix[MAX_PL_PREFIX];
	virtual int idle(int c) { return 0; }
	virtual void displayStatus(void * D, int lineLen)
		{ cprintf("%-*.*s",lineLen,lineLen,
			(char *)D); }
	#pragma argsused
	virtual void displayLine(void * D, int lineLen,
			int cursor = 0)
		{ cprintf("%-*.*s",lineLen,lineLen,
			(char *)D); }
	#pragma argsused
	virtual int xcursor(void * D, const char * prefix,
		int pfLen) { return (pfLen+1); }
	virtual int  match(char *pf, void * D)
		{ return !strncmpi(pf,(char *)D,strlen(pf)); }
public:
	static  Palette defaultP;
	enum PL_PALETTE { COLOR, NORMAL, SELECT,
		STATUS, AUX };
	void setPalette(PalettE P = PalettE0)
		{ this->P = (P? P : defaultP); }
	PickList(int status = 1,
		PalettE P = PalettE0,
		unsigned sizeofEntry = FLstrings,
		unsigned maxEntries = 1024,
		int (*comparE)(const void *, const void *)
			= FLcomparE(strcmp))
		: FlexList(sizeofEntry,maxEntries)
	{
		setPalette(P);
		this->status = status;
		setCompare(comparE);

	}
	unsigned choose(unsigned curRow = 0);
	void *  choice()  { return currentD(); }
	#pragma argsused
	virtual int doIt(void * D)  { return 0; }
	virtual void * addD(void * D)  { return (Compare()?
		insSortD(D) : insQD(D)); }
	virtual int  subtractD(void * D);
};
typedef PickList * PickL;
#define PickL0 ((PickL)0)


class PickListWindow : public PickList, private TextWindow {
protected:
	void putTitle(const char *msg)
		{ TextWindow::putTitle(msg); }
	void putFooter(const char *msg)
		{ TextWindow::putFooter(msg); }
	virtual void dressWindow() { return; }
	virtual unsigned paneWidth() { return 0; }
public:
	TextWindow::setPalette;
	PickListWindow(int status = 1,
		PalettE PLP = PalettE0,
		PalettE TWP = PalettE0,
		unsigned sizeofEntry = FLstrings,
		unsigned maxEntries = 1024,
		int (*comparE)(const void *, const void *)
			= FLcomparE(strcmp))
		: PickList(status,PLP,sizeofEntry,
			maxEntries,comparE),
		TextWindow(TWP) {}
	unsigned choose(int left, int top, int right,
		int bottom, unsigned curRow = 0);
	unsigned choose(unsigned curRow = 0);
};
typedef PickListWindow *PickLW;
#define PickLW0 ((PickLW)0)


#endif
