/*
	sort.cpp -- Container Lite v 1.87
	(C) Copyright 1994  John Webster Small
	All rights reserved
*/

#include "cl.h"

int   cl::sort(voidCmP cmP)
{
	unsigned low, mid, high;
	unsigned d;
	void * D;

/*
	The current node is always reset to undefined
	regardless of the outcome of sort.
*/

	curNode = nodes;
	if (!this->cmP)
		this->cmP = cmPD(voidCmP0);
	if (flags & CL_SORTED)  {
		if (this->cmP == cmP || !cmP)
			return 1;
	}
	else if (!this->cmP && !cmP)
		return 0;
	if (cmP)  {
		this->cmP = cmP;
		flags &= ~CL_SORTED;
	}
	if (!nodes || !linkS)
		return (int) (flags |= CL_SORTED);
	if (first)  {
		/* form contiguous block at front */
		d = (first + nodes) % limit;
		if (d > first)
			memmove(linkS,&linkS[first],
			    sizeof(linkS[0U])*nodes);
		else if (d < first)
			memmove(&linkS[d],
				&linkS[first],
				sizeof(linkS[0U])
				*(limit-first));
		/* else array is full/contiguous */
		first = 0U;
	}
	for (high = d = 1; d < nodes; high = ++d)  {
		low = 0U;
		D = linkS[d];
		while (low < high)  {
			mid = ((high + low) >> 1);
			if ((*this->cmP)(D,
				linkS[mid]) <= 0)
				high = mid;
			else
				low = mid + 1;
		}
		if (high < d)  {
			memmove(&linkS[high+1],
				&linkS[high],
				sizeof(linkS[0U])
				*(d-high));
			linkS[high] = D;
		}
	}
	return (int) (flags |= CL_SORTED);
}
