/*
	cl2.cpp -- Container Lite v 1.87
	(C) Copyright 1994  John Webster Small
	All rights reserved
*/

#include "cl.h"
#include <fstream.h>

ostream& CL_fputCharArray(ostream& os, char * D)
{
	int len = (D? strlen(D) : 0);
	if ((os << len << endm))
		if (len)
			os.write(D,len);
	return os;
}

istream& CL_fgetCharArray(istream& is, char *& D)
{
	if (D)
		delete D;
	int len;
	if ((is >> len >> nextm))
		if (len)  {
	CL_TRY_NEW
		  D = new char[len+1];
	CL_CATCH_XALLOC(D)
		  if (D)  {
			is.read(D,len);
			(D)[len] = '\0';
			return is;
		  }
		}
	return is;
}

int cl::put(ostream& os)
{
	if (!(os << maxNodes << endm << limit << endm
		<< delta << endm << nodes << endm
		<< curNode << endm << flags << endm
		<< cmP2ID(cmP) << endm))
		return 0;
	for (unsigned i = 0U; i < nodes; i++)
		if (!putD(os,atGet(i)))
			return 0;
	return 1;
}

int cl::get(istream& is)
{
	unsigned maxNodes, limit, delta, nodes;
	unsigned curNode, flags, cmPid;

	if (!(is >> maxNodes >> nextm >> limit >> nextm
		>> delta >> nextm >> nodes >> nextm
		>> curNode >> nextm >> flags >> nextm
		>> cmPid >> nextm))
		return 0;
	flags |= CL_DEL;
	//reloaded nodes are dynamic!
	setMaxNodes(maxNodes);
	setLimit(limit);
	setDelta(delta);
	setCmP(ID2cmP(cmPid));
	void * D;
	for (unsigned i = 0U; i < nodes; i++)
		if (!insQ(D=getD(is)))  {
			if (D) deleteD(D);
			break;
		}
	setFlags(flags);  // CL_SORTED may be raised!
	setCurNode(curNode);
	return (nodes == Nodes());
}

int cl::load(const char * filename)
{
	int ok = 0;
	allClr();
	if (filename)  {
		ifstream is(filename);
		if (is)  {
			ok = get(is);
			is.close();
		}
	}
	return ok;
}

int cl::save(const char * filename)
{
	int ok = 0;
	if (Flags(CL_SAVE))  {
		ofstream os(filename);
		if (os)  {
			ok = put(os);
			os.close();
		}
	}
	return ok;
}

unsigned cl::setLimit(unsigned newLimit)
{
	void ** newLinkS;
	unsigned headNodes;

	if (newLimit < nodes)
		newLimit = nodes;
	else if (newLimit > maxNodes)
		newLimit = maxNodes;
	if (newLimit < delta)
		newLimit = delta;
	if (!newLimit || newLimit == limit)
		return 0U;
	if (!linkS)
		return (limit = newLimit);
CL_TRY_NEW
	newLinkS = new void *[newLimit];
CL_CATCH_XALLOC(newLinkS)
	if (!newLinkS)
		return 0U;
	if ((headNodes = limit - first) > nodes)
		headNodes = nodes;
	if (headNodes)  // move leading nodes
		memcpy(newLinkS,&linkS[first],
			sizeof(linkS[0U])*headNodes);
	/* copy wrap around trailing nodes */
	if (headNodes < nodes)
		memcpy(&newLinkS[headNodes],linkS,
			sizeof(linkS[0U])*
			(nodes-headNodes));
	if (newLimit > limit)
		if (newLimit - delta > limit)
			lowLimit = newLimit - delta;
		else
			lowLimit = limit;
	else
		if (newLimit - delta > delta)
			lowLimit = newLimit - delta;
		else
			lowLimit = delta;
	lowThreshold = lowLimit - delta;
	delete linkS;
	linkS = newLinkS;
	limit = newLimit;
	first = 0U;
	return limit;
}

unsigned cl::setDelta(unsigned newDelta)
{
	return ((newDelta && newDelta <= lowLimit)?
		(delta = newDelta) : 0U);
}

unsigned cl::setMaxNodes(unsigned newMaxNodes)
{
	return ((newMaxNodes >= limit)?
		(maxNodes = (newMaxNodes
		> CL_MAXNODES)? CL_MAXNODES
		: newMaxNodes) : 0U);
}

void * cl::atGet(unsigned n) const
{
	return ((linkS && (n < nodes))?
		linkS[(first+n)%limit] : (void *)0);
}

int  cl::setCurNode(unsigned n)
{
	return ((curNode = ((n > nodes)? nodes : n))
		< nodes);
}

struct GenericFnCRecord  {
	GenericFnC fnC;
	unsigned id;
	GenericFnCRecord(GenericFnC fnC, unsigned id)
		{ this->fnC = fnC; this->id = id; }
	~GenericFnCRecord()  {}
};

typedef struct GenericFnCRecord * GenericFnCR;
#define GenericFnCR0  ((GenericFnCR)0)

int FunctionRegistry::regFnC(GenericFnC fnC,
	unsigned id)
{
	unsigned i;

	if (!fnC && !id)  // NULL's id is 0
		return 1;
	if ((!fnC && id) || (fnC && !id))
		return 0;
	for (i = 0U; i < Nodes(); i++)
		if (((GenericFnCR)atGet(i))->id
			== id)
			break;
	if (i < Nodes())
			return 0;
	GenericFnCR R;
CL_TRY_NEW
	R = new GenericFnCRecord(fnC,id);
CL_CATCH_XALLOC(R)
	if (!R)
		return 0;
	else if (!insQ((void *)R))  {
		delete R;
		return 0;
	}
	return 1;
}

unsigned FunctionRegistry::fnC_2_ID(GenericFnC fnC)
{
	GenericFnCR R;
	unsigned i;

	if (!fnC)
		return 0U;
	for (i = 0U; (R = (GenericFnCR) atGet(i))
		!= GenericFnCR0; i++)
		if (R->fnC == fnC)
			return R->id;
	return 0U;
}

GenericFnC FunctionRegistry::ID_2_fnC(unsigned id)
{
	GenericFnCR R;
	unsigned i;

	if (!id)
		return GenericFnC0;
	for (i = 0U; (R = (GenericFnCR) atGet(i))
		!= GenericFnCR0; i++)
		if (R->id == id)
			return R->fnC;
	return GenericFnC0;
}

FunctionRegistry fnCv;

#ifndef CL_NO_TEMPLATES

	#if defined(CL_NO_THROW_XALLOC)\
		&& !defined(CL_NO_EXCEPTIONS)

		char * CL_strdup(const char * D)
		{
			char * newD;
		CL_TRY_NEW
			newD = strdup(D);
		CL_CATCH_XALLOC(newD)
			return newD;
		}

	#endif

#endif
