/*
	winit.cpp  --  read/write configuration-initialization files
*/

#include <ctype.h>

#ifndef winit_h
#include "winit.h"
#endif

#ifdef _MSC_VER
	#define STRNICMP _strnicmp
#else
	#define STRNICMP strnicmp
#endif


int WINIT::setBuf(char * secAndOrParamEq)
{
	if (sec || !secAndOrParamEq)
		return 0;
	if (secAndOrParamEq[0] == '[')  {
		strcpy(buf,secAndOrParamEq);
		sectionLength = (strchr(buf,']') - buf) + 1;
		return 1;
	}
	else if (sectionLength)  {
		strcpy(&buf[sectionLength],secAndOrParamEq);
		return 1;
	}
	return 0;
}

int WINIT::sectionParameterCompare(const char * S1, const char * S2)
{
	int S1Len = strchr(S1,'=') - (char *) S1;
	int S2Len = strchr(S2,'=') - (char *) S2;
	int i = STRNICMP(S1,S2,(S1Len>S2Len)?S1Len:S2Len);
	return i;
}

int WINIT::put(ostream& os)
{
	// see ~WINIT for assumed conditions
	strcpy(buf,top());
	buf[sectionLength=(strchr(buf,']')-buf)+1] = '\0';
	os << buf << endl;
	for (setCurNode(); next(); )  {
		if (STRNICMP(buf,get(),sectionLength))  {
			strcpy(buf,get());
			buf[sectionLength=(strchr(buf,']')-buf)+1] = '\0';
			os << endl << buf << endl;
		}
		os << &(get()[sectionLength]) << endl;
	}
	return 1;
}

int WINIT::get(istream& is)
{
	char * S;
	sectionLength = 0;
	while (is.getline(&buf[sectionLength],sizeof(buf)-sectionLength))  {
		if ((S = strchr(&buf[sectionLength],']')) != 0)  {
			strcpy(buf,&buf[sectionLength]);
			sectionLength = (S - buf) - sectionLength + 1;
			continue;
		}
		// If text doesn't begin in the first column it's ignored!
		if (isspace(buf[sectionLength]) || !buf[sectionLength])
			continue;
		if (sec) if (STRNICMP(sec,buf,sectionLength))
			continue;
		insQNew(buf);
	}
	return 1;
}

WINIT::WINIT(const char * fileName, const char * section)
	: CL_char(defaultConstruct)
{
	sec = section;
	setMaxNodes();
	dirty = !load(fname=fileName);
	setFlags(CL_ANDS);
	setCmP(sectionParameterCompare);
	buf[0] = '\0';	// clear buf for get/setValue
	sectionLength = 0;
}

char * WINIT::getValue(char * secAndOrParamEq,
	char * defVal)
{
	if (!setBuf(secAndOrParamEq))
		return 0;
	if (findFirst(buf))
		return (strchr(get(),'=')+1);
	return defVal;
}

char * WINIT::operator[](char * secAndOrParamEqOptDefVal)
{
	if (!secAndOrParamEqOptDefVal)
		return 0;
	if (strpbrk(secAndOrParamEqOptDefVal,"]="))  {
		char * S = strchr(secAndOrParamEqOptDefVal,'=');
		if (S) if (!*++S) S = 0;
		return getValue(secAndOrParamEqOptDefVal,S);
	}
	return 0;
}

void WINIT::setValue(char * secAndOrParamEq, char * value)
{
	if (!setBuf(secAndOrParamEq))
		return;
	if (value)
		strcpy(strchr(buf,'=')+1,value);
	else
		return;
	if (findFirst(buf)) {
		if (atPutNew(CurNode(),buf))
			dirty = 1;
	}
	else if (insSortNew(buf))
		dirty = 1;
}

WINIT& WINIT::operator<<(char * secAndOrParamEqOptAndOrVal)
{
	if (!secAndOrParamEqOptAndOrVal)
		return *this;
	if (strpbrk(secAndOrParamEqOptAndOrVal,"]="))  {
		char * S = strchr(secAndOrParamEqOptAndOrVal,'=');
		if (S) if (!*++S) S = 0;
		setValue(secAndOrParamEqOptAndOrVal,S);
	}
	else
		setValue(buf,secAndOrParamEqOptAndOrVal);
	return *this;
}

WINIT::~WINIT()
{
	if (dirty && Nodes() && !sec)
		save(fname);
	destruct();
}
