/*
	gconsole.cpp -- graphics console interface
		for Container Lite examples.

	(C) Copyright 1994  John Webster Small
	All rights reserved

	This file has sections set up for Borland's
	BGI and Microsoft's low level graphics run
	time library.  There should be enough
	structure in the two sections provided to 
	allow you to construct sections as required
	for your environment.
*/

// Inclusion of "cl.h" in examples automatically
//	includes "iostream.h" and "iomanip.h"


#include <stdlib.h>	// exit(), random(), randomize()




#if defined(__BORLANDC__) || defined(__TURBOC__)

#include <graphics.h>

#ifndef BGI_PATHNAME
	#define BGI_PATHNAME "\\bc4\\bgi"
#endif

void openGraphics()
{
	int gdriver = (int)DETECT, gmode, errorcode;
	initgraph(&gdriver,&gmode,BGI_PATHNAME);
	errorcode = graphresult();
	if (errorcode != (int)grOk)  {
		cerr << "Graphics error: "
			<< grapherrormsg(errorcode)
			<< "\nProgram Terminating"
			<< endl;
		exit(1);
	}
	randomize();
}

inline void closeGraphics()  { closegraph(); }

inline int GETX()  { return getx(); }
inline int GETY()  { return gety(); }
inline int GETMAXX()  { return getmaxx(); }
inline int GETMAXY()  { return getmaxy(); }
inline int GETRANDX()  { return random(GETMAXX()+1); }
inline int GETRANDY()  { return random(GETMAXY()+1); }
inline int GETCOLOR()  { return getcolor(); }
inline int GETMAXCOLOR()  { return getmaxcolor(); }
inline int GETRANDCOLOR()
	{ return random(GETMAXCOLOR()+1); }
inline void SETCOLOR(int color) { setcolor(color); }
inline int GETRANDANGLE(int startAngle = 0)
	{ return (random(360-startAngle)+startAngle); }

inline void PUTPIX(int x, int y, int color)
	{ putpixel(x,y,color); }

inline void CIRCLE(int x, int y, int radius)
	{ circle(x,y,radius); } 

void RECTANGLE(int l, int t, int r, int b)
{
	int poly[10];

	poly[0] = l;  poly[1] =  t;
	poly[2] = r;  poly[3] =  t;
	poly[4] = r;  poly[5] =  b;
	poly[6] = l;  poly[7] =  b;
	poly[8] = l;  poly[9] =  t;

	drawpoly(5,poly);
}

inline void PIESLICE(int x, int y, int startAngle,
	int endAngle, int radius)
	{ pieslice(x,y,startAngle,endAngle,radius); }


#endif  // Borland/Turbo C/C++





#if defined(_MSC_VER)


#include <graph.h>
#include <math.h>

#include <stdlib.h>	// rand(), srand()
#include <time.h>	// time_t, time()

void randomize()
{
static unsigned rseed = 10;
	if (rseed != 1)  {
		time_t t;
		srand((unsigned) time(&t));
		rseed = 1;
	}
	else
		srand(rseed);
}
inline int random(int max_1)
	{ return (rand() % max_1); }

static _videoconfig vc;

void openGraphics()
{
	(void) _setvideomode(_MAXRESMODE);
	_getvideoconfig(&vc);
	randomize();
}

inline void closeGraphics()
	{ (void) _setvideomode(_DEFAULTMODE); }

inline int GETX()
{
	struct _xycoord position
		= _getcurrentposition();
	return (int) position.xcoord;
}
inline int GETY()
{
	struct _xycoord position
		= _getcurrentposition();
	return (int) position.ycoord;
}
inline int GETMAXX()  { return vc.numxpixels-1; }
inline int GETMAXY()  { return vc.numypixels-1; }
inline int GETRANDX()  { return random(GETMAXX()+1); }
inline int GETRANDY()  { return random(GETMAXY()+1); }
inline int GETCOLOR()  { return (int) _getcolor(); }
inline int GETMAXCOLOR()  { return vc.numcolors-1; }
inline int GETRANDCOLOR()
	{ return random(GETMAXCOLOR()+1); }
inline void SETCOLOR(int color)
	{ _setcolor((short)color); }
inline int GETRANDANGLE(int startAngle = 0)
	{ return (random(360-startAngle)+startAngle); }

void PUTPIX(int x, int y, int color)
{
	int oldcolor = GETCOLOR();
	SETCOLOR(color);
	_setpixel((short)x,(short)y);
	SETCOLOR(oldcolor);
}

inline void CIRCLE(int x, int y, int radius)
{
	_ellipse(_GBORDER,
		(short)(x-radius),(short)(y-radius),
		(short)(x+radius),(short)(y+radius));
} 

inline void RECTANGLE(int l, int t, int r, int b)
{
	_rectangle(_GBORDER,
		(short)l,(short)t,
		(short)r,(short)b);
}

#define deg2rad(degrees) 3.1416*degrees/180.0

inline void PIESLICE(int x, int y, int startAngle,
	int endAngle, int radius)
{
	_pie(_GBORDER,
		(short)(x-radius),(short)(y-radius),
		(short)(x+radius),(short)(y+radius),
		(short)(x+radius*
			cos(deg2rad(startAngle))),
		(short)(y-radius*
			sin(deg2rad(startAngle))),
		(short)(x+radius*
			cos(deg2rad(endAngle))),
		(short)(y-radius*
			sin(deg2rad(endAngle)))
		);
}


#endif  // MSC 7
